/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.mindmap.IdeaShape;

class Idea {
    private final Display label;
    private final int level;
    private final Idea parent;
    private final List<Idea> children = new ArrayList<Idea>();
    private final IdeaShape shape;
    private final HtmlColor backColor;

    public Idea(Display label, IdeaShape shape) {
        this(null, 0, null, label, shape);
    }

    public Idea createIdea(HtmlColor backColor, int newLevel, Display newDisplay, IdeaShape newShape) {
        Idea result = new Idea(backColor, newLevel, this, newDisplay, newShape);
        this.children.add(result);
        return result;
    }

    private Idea(HtmlColor backColor, int level, Idea parent, Display label, IdeaShape shape) {
        this.backColor = backColor;
        this.label = label;
        this.level = level;
        this.parent = parent;
        this.shape = shape;
    }

    public String toString() {
        return this.label.toString();
    }

    public final int getLevel() {
        return this.level;
    }

    public final Display getLabel() {
        return this.label;
    }

    public Collection<Idea> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Idea getParent() {
        return this.parent;
    }

    public final IdeaShape getShape() {
        return this.shape;
    }

    public final HtmlColor getBackColor() {
        return this.backColor;
    }
}

