/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.regex;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MatcherIterator;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.command.regex.RegexResult;

public abstract class RegexComposed
implements IRegex {
    protected static final AtomicInteger nbCreateMatches = new AtomicInteger();
    protected final List<IRegex> partials;
    private Pattern2 fullCached;

    protected abstract String getFullSlow();

    private synchronized Pattern2 getPattern2() {
        if (this.fullCached == null) {
            String fullSlow = this.getFullSlow();
            this.fullCached = MyPattern.cmpile(fullSlow, 2);
        }
        return this.fullCached;
    }

    protected boolean isCompiled() {
        return this.fullCached != null;
    }

    public RegexComposed(IRegex ... partial) {
        this.partials = Arrays.asList(partial);
    }

    @Override
    public Map<String, RegexPartialMatch> createPartialMatch(Iterator<String> it) {
        nbCreateMatches.incrementAndGet();
        HashMap<String, RegexPartialMatch> result = new HashMap<String, RegexPartialMatch>();
        for (IRegex r : this.partials) {
            result.putAll(r.createPartialMatch(it));
        }
        return result;
    }

    @Override
    public final int count() {
        int cpt = this.getStartCount();
        for (IRegex r : this.partials) {
            cpt += r.count();
        }
        return cpt;
    }

    protected int getStartCount() {
        return 0;
    }

    @Override
    public RegexResult matcher(String s) {
        Matcher2 matcher = this.getPattern2().matcher(s);
        if (!matcher.find()) {
            return null;
        }
        MatcherIterator it = new MatcherIterator(matcher);
        return new RegexResult(this.createPartialMatch(it));
    }

    @Override
    public boolean match(StringLocated s) {
        return this.getPattern2().matcher(s.getString()).find();
    }

    @Override
    public final String getPattern() {
        return this.getPattern2().pattern();
    }

    protected final List<IRegex> getPartials() {
        return this.partials;
    }
}

