/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.map;

import de.tum.in.naturals.map.AbstractInt2ObjectEntrySet;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;

public class Nat2ObjectDenseArrayMap<V>
extends AbstractInt2ObjectMap<V> {
    public static final int DEFAULT_SIZE = 16;
    private static final long serialVersionUID = 630710213786009957L;
    private final V[] array;
    @Nullable
    private transient EntrySetView<V> entriesView = null;
    @Nullable
    private transient KeySetView keySetView = null;
    private int size = 0;
    @Nullable
    private transient ValuesView<V> valuesView = null;

    public Nat2ObjectDenseArrayMap(V[] array) {
        this.array = array;
        for (V value : array) {
            if (this.isAbsent(value)) continue;
            ++this.size;
        }
    }

    public Nat2ObjectDenseArrayMap(int size) {
        this.array = new Object[size];
        Arrays.fill(this.array, null);
    }

    public Nat2ObjectDenseArrayMap(int size, V initialValue) {
        this.checkNotAbsent(initialValue);
        this.array = new Object[size];
        Arrays.fill(this.array, initialValue);
        this.size = size;
    }

    public Nat2ObjectDenseArrayMap(int size, IntFunction<V> initialValues) {
        this.array = new Object[size];
        for (int i = 0; i < this.array.length; ++i) {
            V value = initialValues.apply(i);
            this.checkNotAbsent(value);
            this.array[i] = value;
        }
        this.size = size;
    }

    private void checkNotAbsent(@Nullable V value) {
        if (this.isAbsent(value)) {
            throw new NullPointerException("Null value not allowed");
        }
    }

    public void clear() {
        Arrays.fill(this.array, null);
        this.size = 0;
    }

    public boolean containsKey(int key) {
        return 0 <= key && key < this.array.length && !this.isAbsent(this.array[key]);
    }

    public boolean containsValue(@Nullable Object v) {
        if (this.isAbsent(v)) {
            return false;
        }
        for (V value : this.array) {
            if (this.isAbsent(value) || !value.equals(v)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Nat2ObjectDenseArrayMap) {
            Nat2ObjectDenseArrayMap other = (Nat2ObjectDenseArrayMap)((Object)o);
            return this.size == other.size && Arrays.deepEquals(this.array, other.array);
        }
        return super.equals(o);
    }

    public void fill(int from, int to, V value) {
        this.checkNotAbsent(value);
        Arrays.fill(this.array, from, to, value);
    }

    public void fill(PrimitiveIterator.OfInt iterator, V value) {
        this.checkNotAbsent(value);
        while (iterator.hasNext()) {
            this.array[iterator.next().intValue()] = value;
        }
    }

    public V get(int key) {
        V value = this.array[key];
        return (V)(this.isAbsent(value) ? this.defaultReturnValue() : value);
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.array) ^ HashCommon.mix((int)this.size);
    }

    public ObjectSet<Int2ObjectMap.Entry<V>> int2ObjectEntrySet() {
        if (this.entriesView == null) {
            this.entriesView = new EntrySetView(this);
        }
        return new EntrySetView(this);
    }

    private boolean isAbsent(@Nullable Object value) {
        return value == null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public IntSet keySet() {
        if (this.keySetView == null) {
            this.keySetView = new KeySetView(this);
        }
        return this.keySetView;
    }

    private int nextKey(int index) {
        for (int i = index; i < this.array.length; ++i) {
            if (this.isAbsent(this.array[i])) continue;
            return i;
        }
        return -1;
    }

    public V put(int key, V value) {
        this.checkNotAbsent(value);
        V previous = this.array[key];
        this.array[key] = value;
        if (this.isAbsent(previous)) {
            ++this.size;
            return (V)this.defaultReturnValue();
        }
        return previous;
    }

    public V remove(int key) {
        V previous = this.array[key];
        if (this.isAbsent(previous)) {
            return (V)this.defaultReturnValue();
        }
        this.array[key] = null;
        --this.size;
        return previous;
    }

    public int size() {
        return this.size;
    }

    public ObjectCollection<V> values() {
        if (this.valuesView == null) {
            this.valuesView = new ValuesView(this);
        }
        return this.valuesView;
    }

    private static class EntrySetView<V>
    extends AbstractInt2ObjectEntrySet<V, Nat2ObjectDenseArrayMap<V>> {
        EntrySetView(Nat2ObjectDenseArrayMap<V> map) {
            super(map);
        }

        public EntrySetView<V> clone() throws CloneNotSupportedException {
            return (EntrySetView)super.clone();
        }

        public ObjectIterator<Int2ObjectMap.Entry<V>> fastIterator() {
            return new FastEntryIterator((Nat2ObjectDenseArrayMap)this.map);
        }

        public ObjectIterator<Int2ObjectMap.Entry<V>> iterator() {
            return new EntryIterator((Nat2ObjectDenseArrayMap)this.map);
        }
    }

    private static class KeySetView
    extends AbstractIntSet {
        private final Nat2ObjectDenseArrayMap map;

        KeySetView(Nat2ObjectDenseArrayMap map) {
            this.map = map;
        }

        public KeySetView clone() {
            return this;
        }

        public void forEach(IntConsumer action) {
            int index = this.map.nextKey(0);
            while (index >= 0) {
                action.accept(index);
                index = this.map.nextKey(index + 1);
            }
        }

        public IntIterator iterator() {
            return new KeySetIterator(this.map);
        }

        public boolean remove(int key) {
            if (!this.map.containsKey(key)) {
                return false;
            }
            this.map.remove(key);
            return true;
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class ValuesView<V>
    extends AbstractObjectSet<V> {
        private final Nat2ObjectDenseArrayMap<V> map;

        ValuesView(Nat2ObjectDenseArrayMap<V> map) {
            this.map = map;
        }

        public void clear() {
            this.map.clear();
        }

        public ValuesView clone() throws CloneNotSupportedException {
            return (ValuesView)((Object)super.clone());
        }

        public boolean contains(Object v) {
            return this.map.containsValue(v);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection other = (Collection)o;
            return other.size() == this.size() && this.containsAll(other);
        }

        public int hashCode() {
            return HashCommon.mix((int)this.map.hashCode());
        }

        public ObjectIterator<V> iterator() {
            return new ValuesIterator<V>(this.map);
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class ValuesIterator<V>
    implements ObjectIterator<V> {
        private final Nat2ObjectDenseArrayMap<V> map;
        private int current;
        private int next;

        ValuesIterator(Nat2ObjectDenseArrayMap<V> map) {
            this.map = map;
            this.current = -1;
            this.next = ((Nat2ObjectDenseArrayMap)map).nextKey(0);
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object value = ((Nat2ObjectDenseArrayMap)this.map).array[this.next];
            this.current = this.next;
            this.next = ((Nat2ObjectDenseArrayMap)this.map).nextKey(this.next + 1);
            return (V)value;
        }

        public void remove() {
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            this.map.remove(this.current);
            this.current = -1;
        }
    }

    private static class KeySetIterator
    implements IntIterator {
        private final Nat2ObjectDenseArrayMap map;
        private int current = -1;
        private int next;

        KeySetIterator(Nat2ObjectDenseArrayMap map) {
            this.map = map;
            this.next = map.nextKey(0);
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = this.map.nextKey(this.next + 1);
            return this.current;
        }

        public void remove() {
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            this.map.remove(this.current);
            this.current = -1;
        }
    }

    private static class FastMapEntry<V>
    extends AbstractInt2ObjectMap.BasicEntry<V> {
        int index = -1;
        private final Nat2ObjectDenseArrayMap<V> map;

        FastMapEntry(Nat2ObjectDenseArrayMap<V> map) {
            this.map = map;
        }

        public int getIntKey() {
            return this.index;
        }

        public V getValue() {
            return (V)((Nat2ObjectDenseArrayMap)this.map).array[this.index];
        }

        public V setValue(V v) {
            Object oldValue = ((Nat2ObjectDenseArrayMap)this.map).array[this.index];
            ((Nat2ObjectDenseArrayMap)this.map).array[this.index] = v;
            return (V)oldValue;
        }
    }

    private static class FastEntryIterator<V>
    implements ObjectIterator<Int2ObjectMap.Entry<V>> {
        private final FastMapEntry<V> entry;
        private final Nat2ObjectDenseArrayMap<V> map;
        private int next;

        FastEntryIterator(Nat2ObjectDenseArrayMap<V> map) {
            this.entry = new FastMapEntry<V>(map);
            this.map = map;
            this.next = ((Nat2ObjectDenseArrayMap)map).nextKey(0);
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public Int2ObjectMap.Entry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.entry.index = this.next;
            this.next = ((Nat2ObjectDenseArrayMap)this.map).nextKey(this.next + 1);
            return this.entry;
        }

        public void remove() {
            if (this.entry.index == -1) {
                throw new IllegalStateException();
            }
            this.map.remove(this.entry.index);
            this.entry.index = -1;
        }
    }

    private static class EntryIterator<V>
    implements ObjectIterator<Int2ObjectMap.Entry<V>> {
        private final Nat2ObjectDenseArrayMap<V> map;
        private int next;

        EntryIterator(Nat2ObjectDenseArrayMap<V> map) {
            this.map = map;
            this.next = ((Nat2ObjectDenseArrayMap)map).nextKey(0);
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public Int2ObjectMap.Entry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.next;
            this.next = ((Nat2ObjectDenseArrayMap)this.map).nextKey(this.next + 1);
            assert (this.map.containsKey(index));
            return new AbstractInt2ObjectMap.BasicEntry(index, ((Nat2ObjectDenseArrayMap)this.map).array[index]);
        }
    }
}

