/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.mastertheorem;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.collections.Collections3;
import owl.factories.Factories;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.LtlLanguageExpressible;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Rewriter;

public final class AsymmetricEvaluatedFixpoints
implements Comparable<AsymmetricEvaluatedFixpoints>,
LtlLanguageExpressible {
    public final Fixpoints fixpoints;
    public final Set<GOperator> gSafety;
    public final Set<GOperator> gCoSafety;
    public final Set<GOperator> gfCoSafety;
    private final EquivalenceClass language;

    private AsymmetricEvaluatedFixpoints(Fixpoints fixpoints, Set<GOperator> gSafety, Set<GOperator> gCoSafety, Set<GOperator> gfCoSafety, EquivalenceClass language) {
        this.fixpoints = fixpoints;
        this.gSafety = Set.copyOf(gSafety);
        this.gCoSafety = Set.copyOf(gCoSafety);
        this.gfCoSafety = Set.copyOf(gfCoSafety);
        this.language = language;
        assert (this.gSafety.stream().allMatch(SyntacticFragments::isSafety));
        assert (this.gCoSafety.stream().allMatch(SyntacticFragments::isGCoSafety));
        assert (this.gfCoSafety.stream().allMatch(SyntacticFragments::isGfCoSafety));
    }

    @Nullable
    public static AsymmetricEvaluatedFixpoints build(Fixpoints fixpoints, Factories factories) {
        Preconditions.checkArgument((boolean)fixpoints.leastFixpoints().isEmpty());
        Rewriter.ToCoSafety toCoSafety = new Rewriter.ToCoSafety(fixpoints.greatestFixpoints());
        HashSet<GOperator> gOperatorsRewritten = new HashSet<GOperator>();
        for (Formula.TemporalOperator greatestFixpoint : fixpoints.greatestFixpoints()) {
            GOperator gOperator = (GOperator)greatestFixpoint;
            Formula operand = gOperator.operand().substitute(toCoSafety);
            if (BooleanConstant.FALSE.equals(operand)) {
                return null;
            }
            if (BooleanConstant.TRUE.equals(operand)) continue;
            Formula gOperatorRewritten = GOperator.of(operand);
            if (gOperatorRewritten instanceof Conjunction) {
                gOperatorRewritten.operands.forEach(x -> gOperatorsRewritten.add((GOperator)x));
                continue;
            }
            gOperatorsRewritten.add((GOperator)gOperatorRewritten);
        }
        HashSet<GOperator> gSafety = new HashSet<GOperator>();
        HashSet<GOperator> gCoSafety = new HashSet<GOperator>();
        HashSet<GOperator> gfCoSafety = new HashSet<GOperator>();
        for (GOperator gOperator : gOperatorsRewritten) {
            if (SyntacticFragments.isSafety(gOperator)) {
                gSafety.add(gOperator);
                continue;
            }
            if (gOperator.operand() instanceof FOperator) {
                gfCoSafety.add(gOperator);
                continue;
            }
            gCoSafety.add(gOperator);
        }
        EquivalenceClass language = factories.eqFactory.of(Conjunction.of(Stream.concat(gSafety.stream(), Stream.concat(gCoSafety.stream(), gfCoSafety.stream())))).unfold();
        if (language.isFalse() || gOperatorsRewritten.isEmpty()) {
            return null;
        }
        return new AsymmetricEvaluatedFixpoints(fixpoints, gSafety, gCoSafety, gfCoSafety, language);
    }

    @Override
    public int compareTo(AsymmetricEvaluatedFixpoints that) {
        int comparison = this.fixpoints.compareTo(that.fixpoints);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Collections3.compare(this.gSafety, that.gSafety);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Collections3.compare(this.gCoSafety, that.gCoSafety);
        if (comparison != 0) {
            return comparison;
        }
        return Collections3.compare(this.gfCoSafety, that.gfCoSafety);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricEvaluatedFixpoints)) {
            return false;
        }
        AsymmetricEvaluatedFixpoints that = (AsymmetricEvaluatedFixpoints)o;
        return this.fixpoints.equals(that.fixpoints) && this.gSafety.equals(that.gSafety) && this.gCoSafety.equals(that.gCoSafety) && this.gfCoSafety.equals(that.gfCoSafety);
    }

    public int hashCode() {
        return Objects.hash(this.fixpoints, this.gSafety, this.gCoSafety, this.gfCoSafety);
    }

    public boolean isSafety() {
        return this.gCoSafety.isEmpty() && this.gfCoSafety.isEmpty();
    }

    public boolean isLiveness() {
        return this.gSafety.isEmpty() && this.gCoSafety.isEmpty();
    }

    @Override
    public EquivalenceClass language() {
        return this.language;
    }

    public String toString() {
        return String.format("(%s, %s, %s)", new TreeSet<GOperator>(this.gSafety), new TreeSet<GOperator>(this.gCoSafety), new TreeSet<GOperator>(this.gfCoSafety));
    }

    public DeterministicAutomata deterministicAutomata(Factories factories, boolean generalized) {
        DeterministicConstructions.Safety safetyAutomaton = DeterministicConstructions.Safety.of(factories, Conjunction.of(this.gSafety));
        List<EquivalenceClass> coSafety = this.gCoSafety.stream().sorted().map(x -> factories.eqFactory.of(x.operand().unfold())).collect(Collectors.toUnmodifiableList());
        ArrayList<EquivalenceClass> fCoSafety = new ArrayList<EquivalenceClass>();
        DeterministicConstructions.GfCoSafety gfCoSafetyAutomaton = null;
        if (generalized) {
            ArrayList fCoSafetySingleStep = new ArrayList();
            this.gfCoSafety.stream().sorted().forEachOrdered(x -> {
                if (SyntacticFragment.SINGLE_STEP.contains(((FOperator)x.operand()).operand())) {
                    fCoSafetySingleStep.add(x);
                } else {
                    fCoSafety.add(factories.eqFactory.of(x.operand().unfold()));
                }
            });
            if (coSafety.isEmpty() && fCoSafety.isEmpty() && !fCoSafetySingleStep.isEmpty()) {
                fCoSafety.add(factories.eqFactory.of(((GOperator)fCoSafetySingleStep.remove(0)).operand()).unfold());
            }
            if (!fCoSafetySingleStep.isEmpty()) {
                gfCoSafetyAutomaton = DeterministicConstructions.GfCoSafety.of(factories, new HashSet(fCoSafetySingleStep), true);
            }
        } else {
            this.gfCoSafety.stream().sorted().forEachOrdered(x -> fCoSafety.add(factories.eqFactory.of(x.operand().unfold())));
        }
        assert (!((EquivalenceClass)safetyAutomaton.onlyInitialState()).isFalse());
        return new DeterministicAutomata(gfCoSafetyAutomaton, safetyAutomaton, coSafety, fCoSafety);
    }

    public static final class DeterministicAutomata {
        @Nullable
        public final DeterministicConstructions.GfCoSafety gfCoSafetyAutomaton;
        public final DeterministicConstructions.Safety safetyAutomaton;
        public final List<EquivalenceClass> coSafety;
        public final List<EquivalenceClass> fCoSafety;

        private DeterministicAutomata(@Nullable DeterministicConstructions.GfCoSafety gfCoSafetyAutomaton, DeterministicConstructions.Safety safetyAutomaton, List<EquivalenceClass> coSafety, List<EquivalenceClass> fCoSafety) {
            this.gfCoSafetyAutomaton = gfCoSafetyAutomaton;
            this.safetyAutomaton = safetyAutomaton;
            this.coSafety = List.copyOf(coSafety);
            this.fCoSafety = List.copyOf(fCoSafety);
        }
    }
}

