/*
 * Decompiled with CFR 0.152.
 */
package owl.game.output;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import owl.game.output.AutoValue_Aig;

@AutoValue
public abstract class Aig {
    public static final Aig FALSE = new AutoValue_Aig(0, null, false, null, false);

    public abstract int variable();

    @Nullable
    public abstract Aig left();

    public abstract boolean leftIsNegated();

    @Nullable
    public abstract Aig right();

    public abstract boolean rightIsNegated();

    public static Aig leaf(int variable) {
        Preconditions.checkArgument((variable > 0 ? 1 : 0) != 0, (Object)"Variables need to have positive indices");
        return new AutoValue_Aig(variable, null, false, null, false);
    }

    public static Aig node(Aig left, Aig right) {
        return new AutoValue_Aig(0, left, false, right, false);
    }

    public static Aig node(Aig left, boolean leftNegated, Aig right, boolean rightNegated) {
        return new AutoValue_Aig(0, left, leftNegated, right, rightNegated);
    }

    public boolean isLeaf() {
        return this.left() == null && this.right() == null;
    }

    public boolean isConstant() {
        return this == FALSE;
    }

    public boolean isVariable() {
        return this.isLeaf() && !this.isConstant();
    }
}

