/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.simulations.SimulationStates;
import owl.automaton.algorithm.simulations.SimulationType;
import owl.automaton.algorithm.simulations.Transition;
import owl.automaton.edge.Edge;
import owl.collections.Pair;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;
import owl.run.Environment;

public class ForwardDirectLookaheadSimulation<S>
implements SimulationType<S, SimulationStates.LookaheadSimulationState<S>> {
    final Automaton<S, BuchiAcceptance> leftAutomaton;
    final Automaton<S, BuchiAcceptance> rightAutomaton;
    final ValuationSetFactory factory;
    final S leftState;
    final S rightState;
    final SimulationStates.LookaheadSimulationState<S> initialState;
    final SimulationStates.LookaheadSimulationState<S> sinkState;
    final Set<Pair<S, S>> knownPairs;
    final int maxLookahead;

    public ForwardDirectLookaheadSimulation(Automaton<S, BuchiAcceptance> leftAutomaton, Automaton<S, BuchiAcceptance> rightAutomaton, S left, S right, int maxLookahead, Set<Pair<S, S>> known) {
        this.leftAutomaton = leftAutomaton;
        this.rightAutomaton = rightAutomaton;
        this.leftState = left;
        this.rightState = right;
        this.maxLookahead = maxLookahead;
        this.knownPairs = known;
        this.factory = Environment.annotated().factorySupplier().getValuationSetFactory(List.of("a"));
        this.initialState = SimulationStates.LookaheadSimulationState.of(left, right);
        this.sinkState = SimulationStates.LookaheadSimulationState.of(left, right, List.of());
    }

    @Override
    public Map<Edge<SimulationStates.LookaheadSimulationState<S>>, ValuationSet> edgeMap(SimulationStates.LookaheadSimulationState<S> state) {
        HashMap<Edge<SimulationStates.LookaheadSimulationState<S>>, ValuationSet> out = new HashMap<Edge<SimulationStates.LookaheadSimulationState<S>>, ValuationSet>();
        if (state.equals(this.sinkState)) {
            out.put(Edge.of(this.sinkState, 1), this.factory.universe());
            return out;
        }
        if (state.owner().isOdd()) {
            Set<List<Transition<S>>> possible = Transition.universe(state.odd(), this.leftAutomaton, this.maxLookahead);
            if (possible.isEmpty()) {
                out.put(Edge.of(state, 0), this.factory.universe());
                return out;
            }
            possible.forEach(moves -> {
                SimulationStates.LookaheadSimulationState target = SimulationStates.LookaheadSimulationState.of(state.odd(), state.even(), moves);
                out.put(Edge.of(target, 0), this.factory.universe());
            });
        } else {
            Set<List<Transition<S>>> possible = Transition.directMatching(state.even(), this.rightAutomaton, state.moves());
            if (possible.isEmpty()) {
                out.put(Edge.of(this.sinkState, 1), this.factory.universe());
                return out;
            }
            possible.forEach(move -> {
                SimulationStates.LookaheadSimulationState target = SimulationStates.LookaheadSimulationState.of(Transition.at(state.moves(), move.size()), Transition.end(move));
                out.put(Edge.of(target, 0), this.factory.universe());
            });
        }
        return out;
    }

    @Override
    public Set<SimulationStates.LookaheadSimulationState<S>> states() {
        HashSet out = new HashSet();
        this.leftAutomaton.states().forEach(left -> this.rightAutomaton.states().forEach(right -> {
            out.add(SimulationStates.LookaheadSimulationState.of(left, right));
            Transition.universe(left, this.leftAutomaton, this.maxLookahead).forEach(moves -> out.add(SimulationStates.LookaheadSimulationState.of(left, right, moves)));
        }));
        return out;
    }

    @Override
    public ParityAcceptance acceptance() {
        return new ParityAcceptance(2, ParityAcceptance.Parity.MAX_EVEN);
    }

    @Override
    public Set<SimulationStates.LookaheadSimulationState<S>> initialStates() {
        return Set.of(this.initialState);
    }

    @Override
    public ValuationSetFactory factory() {
        return this.factory;
    }

    public static <S> ForwardDirectLookaheadSimulation<S> of(Automaton<S, BuchiAcceptance> leftAutomaton, Automaton<S, BuchiAcceptance> rightAutomaton, S left, S right, int maxLookahead, Set<Pair<S, S>> known) {
        return new ForwardDirectLookaheadSimulation<S>(leftAutomaton, rightAutomaton, left, right, maxLookahead, known);
    }
}

