/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.dra2dpa;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import de.tum.in.naturals.IntPreOrder;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import owl.automaton.AbstractImmutableAutomaton;
import owl.automaton.Automaton;
import owl.automaton.EmptyAutomaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.SingletonAutomaton;
import owl.automaton.Views;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.automaton.acceptance.optimization.ParityAcceptanceOptimizations;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModule;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.dra2dpa.IARState;

public final class IARBuilder<R> {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("dra2dpa", "Converts a Rabin automaton into a parity automaton", new Options().addOption(new Option(null, "odd", false, "Odd priority (default: even)")).addOption(new Option(null, "min", false, "Min priority (default: max)")), (commandLine, environment) -> {
        ParityAcceptance.Parity parity = ParityAcceptance.Parity.of(!commandLine.hasOption("min"), !commandLine.hasOption("odd"));
        return OwlModule.AutomatonTransformer.of(automaton -> new IARBuilder(automaton, parity).build(), RabinAcceptance.class);
    });
    private final Automaton<R, RabinAcceptance> rabinAutomaton;
    private final ParityAcceptance.Parity parity;

    public IARBuilder(Automaton<R, RabinAcceptance> rabinAutomaton, ParityAcceptance.Parity parity) {
        this.rabinAutomaton = rabinAutomaton;
        this.parity = parity;
    }

    public static void main(String ... args) throws IOException {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.of(InputReaders.HOA_INPUT_MODULE, List.of(AcceptanceOptimizations.MODULE), MODULE, List.of(AcceptanceOptimizations.MODULE), OutputWriters.HOA_OUTPUT_MODULE));
    }

    public Automaton<IARState<R>, ParityAcceptance> build() {
        int rejectingPriority;
        if (this.rabinAutomaton.initialStates().isEmpty()) {
            return EmptyAutomaton.of(this.rabinAutomaton.factory(), new ParityAcceptance(1, this.parity));
        }
        RabinAcceptance rabinAcceptance = this.rabinAutomaton.acceptance();
        Set<GeneralizedRabinAcceptance.RabinPair> rabinPairs = Set.copyOf(rabinAcceptance.pairs());
        int n = rejectingPriority = this.parity.even() ? 1 : 0;
        if (rabinPairs.isEmpty()) {
            R rabinState = this.rabinAutomaton.initialStates().iterator().next();
            ParityAcceptance acceptance = new ParityAcceptance(this.parity.even() ? 2 : 1, this.parity);
            return SingletonAutomaton.of(this.rabinAutomaton.factory(), IARState.of(rabinState), acceptance, acceptance.rejectingSet().orElseThrow());
        }
        HashMultimap stateMap = HashMultimap.create();
        ParityAcceptance acceptance = new ParityAcceptance(0, this.parity);
        HashMapAutomaton<IARState<R>, ParityAcceptance> resultAutomaton = HashMapAutomaton.of(acceptance, this.rabinAutomaton.factory());
        List<Set<R>> decomposition = SccDecomposition.of(this.rabinAutomaton).sccsWithoutTransient();
        HashSet<R> missingStates = new HashSet<R>(this.rabinAutomaton.states());
        decomposition.forEach(missingStates::removeAll);
        for (Set<R> set : decomposition) {
            HashSet<GeneralizedRabinAcceptance.RabinPair> noInfEdgePairs = new HashSet<GeneralizedRabinAcceptance.RabinPair>(rabinPairs);
            for (Object state : set) {
                for (Edge<R> edge2 : this.rabinAutomaton.edges(state)) {
                    noInfEdgePairs.removeIf(pair -> edge2.inSet(pair.infSet()));
                }
            }
            Set<GeneralizedRabinAcceptance.RabinPair> set2 = Set.copyOf(Sets.difference(rabinPairs, noInfEdgePairs));
            if (set2.isEmpty()) {
                Object state;
                for (Object e : set) {
                    IARState iarState = IARState.of(e);
                    resultAutomaton.addState(iarState);
                    stateMap.put(e, iarState);
                }
                state = set.iterator();
                while (state.hasNext()) {
                    Object e = state.next();
                    this.rabinAutomaton.edgeMap(e).forEach((edge, valuation) -> {
                        if (scc.contains(edge.successor())) {
                            resultAutomaton.addEdge((IARState)IARState.of(state2), (ValuationSet)valuation, (Edge)Edge.of(IARState.of(edge.successor()), rejectingPriority));
                        }
                    });
                }
                continue;
            }
            Views.Filter<Object> sccFilter = Views.Filter.of(Set.of(set.iterator().next()), set::contains);
            Automaton<Object, RabinAcceptance> automaton = Views.filtered(this.rabinAutomaton, sccFilter);
            MutableAutomaton<IARState<Object>, ParityAcceptance> subAutomaton = this.build(automaton, set2);
            MutableAutomatonUtil.copyInto(subAutomaton, resultAutomaton);
            subAutomaton.states().forEach(arg_0 -> IARBuilder.lambda$build$4((Multimap)stateMap, arg_0));
            assert (subAutomaton.states().stream().map(IARState::state).collect(Collectors.toSet()).equals(set));
        }
        for (Set<Object> set : missingStates) {
            IARState<Set<Object>> iarState = IARState.of(set);
            resultAutomaton.addState(iarState);
            stateMap.put(set, iarState);
        }
        for (Set<Object> set : decomposition) {
            for (Object e : set) {
                Collection iarStates = stateMap.get(e);
                this.rabinAutomaton.edgeMap(e).forEach((arg_0, arg_1) -> IARBuilder.lambda$build$5(set, (Multimap)stateMap, iarStates, resultAutomaton, arg_0, arg_1));
            }
        }
        for (Set<Object> set : missingStates) {
            Collection iarStates = stateMap.get(set);
            this.rabinAutomaton.edgeMap(set).forEach((arg_0, arg_1) -> IARBuilder.lambda$build$6((Multimap)stateMap, iarStates, resultAutomaton, arg_0, arg_1));
        }
        assert (Objects.equals(stateMap.keySet(), this.rabinAutomaton.states()));
        resultAutomaton.initialStates(this.rabinAutomaton.initialStates().stream().map(arg_0 -> ((Multimap)stateMap).get(arg_0)).map(Collection::iterator).map(Iterator::next).collect(Collectors.toSet()));
        resultAutomaton.trim();
        this.optimizeInitialStates(resultAutomaton, false);
        resultAutomaton.trim();
        ParityAcceptanceOptimizations.setAcceptingSets(resultAutomaton);
        return resultAutomaton;
    }

    private void optimizeInitialStates(MutableAutomaton<IARState<R>, ParityAcceptance> automaton, boolean singleScc) {
        SccDecomposition<IARState<R>> sccDecomposition = SccDecomposition.of(automaton);
        List sccs = Lists.reverse(sccDecomposition.sccsWithoutTransient());
        ArrayList<IARState> newInitialStates = new ArrayList<IARState>();
        Set initialStatesToSearch = automaton.initialStates().stream().map(IARState::state).collect(Collectors.toSet());
        Iterable statesToSearch = singleScc ? (Iterable)sccs.stream().filter(sccDecomposition::isBottomScc).findAny().orElseThrow() : Iterables.concat((Iterable)sccs);
        for (IARState state : statesToSearch) {
            Object rabinState = state.state();
            if (!initialStatesToSearch.remove(rabinState)) continue;
            newInitialStates.add(state);
            if (!initialStatesToSearch.isEmpty()) continue;
            break;
        }
        if (!initialStatesToSearch.isEmpty()) {
            assert (!singleScc);
            Set foundInitialStates = newInitialStates.stream().map(IARState::state).collect(Collectors.toSet());
            automaton.initialStates().stream().filter(s -> !foundInitialStates.contains(s.state())).forEach(newInitialStates::add);
        }
        assert (newInitialStates.stream().map(IARState::state).collect(Collectors.toSet()).equals(automaton.initialStates().stream().map(IARState::state).collect(Collectors.toSet())));
        automaton.initialStates(newInitialStates);
        automaton.trim();
    }

    private void optimizeStateRefinement(MutableAutomaton<IARState<R>, ParityAcceptance> automaton) {
        HashMap<Object, Multimap> topElements = new HashMap<Object, Multimap>();
        for (IARState state : automaton.states()) {
            Multimap refinements = topElements.computeIfAbsent(state.state(), k -> ArrayListMultimap.create());
            Iterator iterator = refinements.asMap().entrySet().iterator();
            ArrayList<IntPreOrder> refined = new ArrayList<IntPreOrder>();
            IntPreOrder stateOrder = state.record();
            boolean isTop = true;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                IntPreOrder entryOrder = (IntPreOrder)entry.getKey();
                if (entryOrder.refines(stateOrder)) {
                    ((Collection)entry.getValue()).add(stateOrder);
                    isTop = false;
                    break;
                }
                if (!stateOrder.refines(entryOrder)) continue;
                refined.add(entryOrder);
                refined.addAll((Collection)entry.getValue());
                iterator.remove();
            }
            if (!isTop) continue;
            refined.add(stateOrder);
            refinements.putAll((Object)stateOrder, refined);
        }
        HashBasedTable refinementTable = HashBasedTable.create();
        for (Map.Entry entry : topElements.entrySet()) {
            Object rabinState = entry.getKey();
            Multimap refinements = (Multimap)entry.getValue();
            refinements.forEach((arg_0, arg_1) -> IARBuilder.lambda$optimizeStateRefinement$9((Table)refinementTable, rabinState, arg_0, arg_1));
        }
        automaton.initialStates(automaton.initialStates().stream().map(arg_0 -> IARBuilder.lambda$optimizeStateRefinement$10((Table)refinementTable, arg_0)).collect(Collectors.toSet()));
        automaton.updateEdges((arg_0, arg_1) -> IARBuilder.lambda$optimizeStateRefinement$11((Table)refinementTable, arg_0, arg_1));
        automaton.trim();
    }

    private IARExplorer<R> explorer(Automaton<R, RabinAcceptance> rabinAutomaton, Set<GeneralizedRabinAcceptance.RabinPair> activeRabinPairs) {
        int numberOfTrackedPairs = activeRabinPairs.size();
        IntPreOrder initialRecord = IntPreOrder.coarsest((int)numberOfTrackedPairs);
        Set initialStates = rabinAutomaton.initialStates().stream().map(initialRabinState -> IARState.of(initialRabinState, initialRecord)).collect(Collectors.toSet());
        return new IARExplorer<R>(rabinAutomaton, initialStates, activeRabinPairs, this.parity);
    }

    private MutableAutomaton<IARState<R>, ParityAcceptance> build(Automaton<R, RabinAcceptance> rabinAutomaton, Set<GeneralizedRabinAcceptance.RabinPair> activeRabinPairs) {
        assert (SccDecomposition.of(rabinAutomaton).sccs().size() == 1);
        IARExplorer<R> explorer = this.explorer(rabinAutomaton, activeRabinPairs);
        MutableAutomaton<IARState<R>, ParityAcceptance> resultAutomaton = MutableAutomatonUtil.asMutable(explorer);
        this.optimizeInitialStates(resultAutomaton, true);
        assert (SccDecomposition.of(resultAutomaton).sccs().size() == 1);
        this.optimizeStateRefinement(resultAutomaton);
        return resultAutomaton;
    }

    private static /* synthetic */ Edge lambda$optimizeStateRefinement$11(Table refinementTable, IARState state, Edge edge) {
        IARState successor = (IARState)edge.successor();
        IARState refinedSuccessor = (IARState)refinementTable.get(successor.state(), (Object)successor.record());
        return refinedSuccessor == null ? edge : edge.withSuccessor(refinedSuccessor);
    }

    private static /* synthetic */ IARState lambda$optimizeStateRefinement$10(Table refinementTable, IARState initialState) {
        return Objects.requireNonNullElse((IARState)refinementTable.get(initialState.state(), (Object)initialState.record()), initialState);
    }

    private static /* synthetic */ void lambda$optimizeStateRefinement$9(Table refinementTable, Object rabinState, IntPreOrder precise, IntPreOrder coarse) {
        if (!coarse.equals((Object)precise)) {
            refinementTable.put(rabinState, (Object)coarse, IARState.of(rabinState, precise));
        }
    }

    private static /* synthetic */ void lambda$build$6(Multimap stateMap, Collection iarStates, MutableAutomaton resultAutomaton, Edge edge, ValuationSet valuation) {
        Object successor = edge.successor();
        IARState successorIar = (IARState)stateMap.get(successor).iterator().next();
        for (IARState iarState : iarStates) {
            resultAutomaton.addEdge(iarState, valuation, Edge.of(successorIar));
        }
    }

    private static /* synthetic */ void lambda$build$5(Set scc, Multimap stateMap, Collection iarStates, MutableAutomaton resultAutomaton, Edge edge, ValuationSet valuation) {
        Object successor = edge.successor();
        if (!scc.contains(successor)) {
            IARState successorIar = (IARState)stateMap.get(successor).iterator().next();
            for (IARState iarState : iarStates) {
                resultAutomaton.addEdge(iarState, valuation, Edge.of(successorIar));
            }
        }
    }

    private static /* synthetic */ void lambda$build$4(Multimap stateMap, IARState state) {
        stateMap.put(state.state(), (Object)state);
    }

    private static final class IARExplorer<S>
    extends AbstractImmutableAutomaton<IARState<S>, ParityAcceptance> {
        private final Automaton<S, RabinAcceptance> rabinAutomaton;
        private final GeneralizedRabinAcceptance.RabinPair[] indexToPair;
        private final ParityAcceptance.Parity parity;

        IARExplorer(Automaton<S, RabinAcceptance> rabinAutomaton, Set<IARState<S>> initialStates, Set<GeneralizedRabinAcceptance.RabinPair> trackedPairs, ParityAcceptance.Parity parity) {
            super(rabinAutomaton.factory(), initialStates, new ParityAcceptance(0, parity));
            this.rabinAutomaton = rabinAutomaton;
            this.indexToPair = (GeneralizedRabinAcceptance.RabinPair[])trackedPairs.toArray(GeneralizedRabinAcceptance.RabinPair[]::new);
            this.parity = parity;
        }

        @Override
        @Nullable
        public Edge<IARState<S>> edge(IARState<S> state, BitSet valuation) {
            Edge<S> edge = this.rabinAutomaton.edge(state.state(), valuation);
            return edge == null ? null : this.computeSuccessorEdge(state.record(), edge);
        }

        @Override
        public Set<Edge<IARState<S>>> edges(IARState<S> state) {
            IntPreOrder record = state.record();
            return Collections3.transformSet(this.rabinAutomaton.edges(state.state()), edge -> this.computeSuccessorEdge(record, (Edge<S>)edge));
        }

        @Override
        public Set<Edge<IARState<S>>> edges(IARState<S> state, BitSet valuation) {
            IntPreOrder record = state.record();
            return Collections3.transformSet(this.rabinAutomaton.edges(state.state(), valuation), edge -> this.computeSuccessorEdge(record, (Edge<S>)edge));
        }

        @Override
        public Map<Edge<IARState<S>>, ValuationSet> edgeMap(IARState<S> state) {
            IntPreOrder record = state.record();
            return Collections3.transformMap(this.rabinAutomaton.edgeMap(state.state()), rabinState -> this.computeSuccessorEdge(record, (Edge<S>)rabinState));
        }

        @Override
        public ValuationTree<Edge<IARState<S>>> edgeTree(IARState<S> state) {
            IntPreOrder record = state.record();
            return this.rabinAutomaton.edgeTree(state.state()).map(edges -> Collections3.transformSet(edges, edge -> this.computeSuccessorEdge(record, (Edge<S>)edge)));
        }

        @Override
        public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
            return this.rabinAutomaton.preferredEdgeAccess();
        }

        private Edge<IARState<S>> computeSuccessorEdge(IntPreOrder record, Edge<S> rabinEdge) {
            int priority;
            S rabinSuccessor = rabinEdge.successor();
            int classCount = record.classes();
            if (classCount == 0) {
                int priority2 = this.parity.even() ? 1 : 0;
                return Edge.of(IARState.of(rabinEdge.successor()), priority2);
            }
            int matchOffset = 0;
            boolean infMatch = false;
            IntAVLTreeSet seenFin = new IntAVLTreeSet();
            int currentOffset = 0;
            for (int currentClass = 0; currentClass < classCount; ++currentClass) {
                int[] classes = record.equivalenceClass(currentClass);
                currentOffset += classes.length;
                for (int rabinIndex : classes) {
                    GeneralizedRabinAcceptance.RabinPair rabinPair = this.indexToPair[rabinIndex];
                    if (rabinEdge.inSet(rabinPair.finSet())) {
                        matchOffset = currentOffset;
                        infMatch = false;
                        seenFin.add(rabinIndex);
                        continue;
                    }
                    if (matchOffset >= currentOffset || !rabinEdge.inSet(rabinPair.infSet())) continue;
                    matchOffset = currentOffset;
                    infMatch = true;
                }
            }
            if (this.parity.max()) {
                priority = this.parity.even() ? (matchOffset == 0 ? 1 : (infMatch ? matchOffset * 2 : matchOffset * 2 + 1)) : (matchOffset == 0 ? 0 : (infMatch ? matchOffset * 2 + 1 : matchOffset * 2 + 2));
            } else {
                int inverse = (this.indexToPair.length - matchOffset + 1) * 2;
                if (this.parity.even()) {
                    priority = matchOffset == 0 ? this.indexToPair.length * 2 + 1 : (infMatch ? inverse : inverse - 1);
                } else if (matchOffset == 0) {
                    priority = this.indexToPair.length * 2;
                } else {
                    int n = priority = infMatch ? inverse - 1 : inverse - 2;
                }
            }
            assert (priority >= 0 || matchOffset == 0) : "Negative priority for " + this.parity + ": Match at " + matchOffset + " (" + (infMatch ? "INF" : "FIN") + "), " + this.indexToPair.length;
            IntPreOrder successorRecord = record;
            Object object = seenFin.iterator();
            while (object.hasNext()) {
                int index = (Integer)object.next();
                successorRecord = successorRecord.generation(IntSets.singleton((int)index));
            }
            IARState<S> successorState = IARState.of(rabinSuccessor, successorRecord);
            return Edge.of(successorState, priority);
        }
    }
}

