/*
 * Decompiled with CFR 0.152.
 */
package owl.run;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import owl.run.Pipeline;
import owl.run.RunUtil;
import owl.run.modules.OwlModuleRegistry;
import owl.run.parser.OwlParser;
import owl.util.GuardedStream;

public final class DefaultCli {
    private DefaultCli() {
    }

    public static void main(String ... args) throws IOException {
        OwlParser parseResult = OwlParser.parse(args, (CommandLineParser)new DefaultParser(), DefaultCli.getOptions(), OwlModuleRegistry.DEFAULT_REGISTRY);
        if (parseResult == null) {
            System.exit(1);
            return;
        }
        DefaultCli.run(parseResult.globalSettings, parseResult.pipeline);
    }

    public static Options getOptions() {
        Option fileInput = new Option("I", "filein", true, "Read input from the specified file (- for stdin)");
        Option fixedInput = new Option("i", "input", true, "Use given strings as input");
        OptionGroup inputGroup = new OptionGroup().addOption(fileInput).addOption(fixedInput);
        Option fileOutput = new Option("O", "fileout", true, "Write output to the specified file (- for stdout)");
        return new Options().addOptionGroup(inputGroup).addOption(fileOutput).addOption(RunUtil.getDefaultAnnotationOption());
    }

    public static void run(CommandLine settings, Pipeline pipeline) throws IOException {
        ReadableByteChannel reader;
        if (settings.hasOption("filein")) {
            String[] sources = settings.getOptionValues("filein");
            if (sources.length != 1) {
                throw RunUtil.failWithMessage("Multiple sources specified");
            }
            reader = sources[0].trim().equals("-") ? Channels.newChannel(System.in) : Files.newByteChannel(Paths.get(sources[0], new String[0]), StandardOpenOption.READ);
        } else if (settings.hasOption("input")) {
            reader = DefaultCli.createReader(List.of(settings.getOptionValues("input")));
        } else if (!settings.getArgList().isEmpty()) {
            reader = DefaultCli.createReader(settings.getArgList());
            settings.getArgList().clear();
        } else {
            reader = Channels.newChannel(System.in);
        }
        String destination = settings.getOptionValue("fileout");
        WritableByteChannel writer = destination == null || "-".equals(destination) ? Channels.newChannel(GuardedStream.sysout) : Files.newByteChannel(Paths.get(destination, new String[0]), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        try (ReadableByteChannel readableByteChannel = reader;
             WritableByteChannel writableByteChannel = writer;){
            pipeline.run(reader, writer);
        }
    }

    private static ReadableByteChannel createReader(List<String> inputs) {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        inputs.forEach(joiner::add);
        byte[] bytes = joiner.toString().getBytes(StandardCharsets.UTF_8);
        return Channels.newChannel(new ByteArrayInputStream(bytes));
    }
}

