/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.mocks;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.tools.mocks.MockPluginElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockExtension
extends MockPluginElement<Extension>
implements Extension {
    private String extendedPluginId;
    private String extendedPointId;
    private boolean isValid = true;
    private LinkedList<Extension.Parameter> parameters = new LinkedList();

    public MockExtension() {
    }

    public MockExtension(String id) {
        this.setId(id);
    }

    public MockExtension(String id, PluginDescriptor declaringPluginDescriptor) {
        this.setDeclaringPluginDescriptor(declaringPluginDescriptor);
        this.setId(id);
    }

    @Override
    public String getExtendedPluginId() {
        return this.extendedPluginId;
    }

    public MockExtension setExtendedPluginId(String value) {
        this.extendedPluginId = value;
        return this;
    }

    @Override
    public String getExtendedPointId() {
        return this.extendedPointId;
    }

    public MockExtension setExtendedPointId(String value) {
        this.extendedPointId = value;
        return this;
    }

    @Override
    public Extension.Parameter getParameter(String id) {
        for (Extension.Parameter param : this.parameters) {
            if (!param.getId().equals(id)) continue;
            return param;
        }
        throw new IllegalArgumentException("unknown parameter ID " + id);
    }

    @Override
    public Collection<Extension.Parameter> getParameters() {
        return Collections.unmodifiableCollection(this.parameters);
    }

    @Override
    public Collection<Extension.Parameter> getParameters(String id) {
        LinkedList<Extension.Parameter> result = new LinkedList<Extension.Parameter>();
        for (Extension.Parameter param : this.parameters) {
            if (!param.getId().equals(id)) continue;
            result.add(param);
        }
        return result;
    }

    public MockExtension addParameter(Extension.Parameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public MockExtension setValid(boolean value) {
        this.isValid = value;
        return this;
    }

    @Override
    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getId() + '@' + this.getId();
    }
}

