/*
 *  file overloading.cc
 *
 *  Copyright (C) 2000 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// concepts' definition


template< class Model1 >
struct Concept1_traits {};

template< class Model1 >
struct Concept1
{
  void meth1() { self().meth1_impl(); }
protected:
  Model1& self()
   { return static_cast< Model1& >( *this ); }
};


template< class Model2 >
struct Concept2_traits {};

template< class Model2 >
struct Concept2
{
  void meth2() { self().meth2_impl(); }
protected:
  Model2& self()
   { return static_cast< Model2& >( *this ); }
};


template< class Model3 >
struct Concept3_traits {};

template< class Model3 >
struct Concept3
{
  void meth3() { self().meth3_impl(); }
protected:
  Model3& self()
   { return static_cast< Model3& >( *this ); }
};



// generic procedures


template< class Model1, class Model2 >
void foo( Concept1< Model1 >& arg1, Concept2< Model2 >& arg2 )
{
  std::cout << "foo( Concept1, Concept2 ):" << std::endl;
  arg1.meth1();
  arg2.meth2();
}


template< class Model2, class Model1 >
void foo( Concept2< Model2 >& arg1, Concept1< Model1 >& arg2 )
{
  std::cout << "foo( Concept2, Concept1 ):" << std::endl;
  arg1.meth2();
  arg2.meth1();
}


template< class Model1, class Model3 >
void foo( Concept1< Model1 >& arg1, Concept3< Model3 >& arg2 )
{
  std::cout << "foo( Concept1, Concept3 ):" << std::endl;
  arg1.meth1();
  arg2.meth3();
}



// models


struct M1 : public Concept1< M1 >
{
  void meth1_impl()
  {
    std::cout << "M1::meth1_impl()" << std::endl;
  }
};


struct M2 : public Concept2< M2 >
{
  void meth2_impl()
  {
    std::cout << "M2::meth2_impl()" << std::endl;
  }
};


struct M3 : public Concept3< M3 >
{
  void meth3_impl()
  {
    std::cout << "M3::meth3_impl()" << std::endl;
  }
};



// main


int main()
{
  M1 m1;
  M2 m2;
  M3 m3;

  foo( m1, m2 );
  std::cout << std::endl;

  foo( m2, m1 );
  std::cout << std::endl;

  foo( m1, m3 );
}
