/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.style.CommandStyleMultilines;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;

public class StyleLoader {
    private final SkinParam skinParam;
    private StyleBuilder result;

    public static StyleBuilder mainStyle(SkinParam skinParam) throws IOException {
        return new StyleLoader(skinParam).loadSkin("plantuml.skin");
    }

    public StyleLoader(SkinParam skinParam) {
        this.skinParam = skinParam;
    }

    public StyleBuilder loadSkin(String filename) throws IOException {
        this.result = new StyleBuilder(this.skinParam);
        InputStream internalIs = null;
        File localFile = new File(filename);
        Log.info("Trying to load style " + filename);
        if (!localFile.exists()) {
            localFile = FileSystem.getInstance().getFile(filename);
        }
        if (localFile.exists()) {
            Log.info("File found : " + localFile.getAbsolutePath());
            internalIs = new FileInputStream(localFile);
        } else {
            Log.info("File not found");
            String res = "/skin/" + filename;
            internalIs = StyleLoader.class.getResourceAsStream(res);
        }
        if (internalIs == null) {
            return null;
        }
        BlocLines lines2 = BlocLines.load(internalIs, (LineLocation)new LineLocationImpl(filename, null));
        this.loadSkinInternal(lines2);
        return this.result;
    }

    private void loadSkinInternal(BlocLines lines) {
        CommandStyleMultilines cmd2 = new CommandStyleMultilines();
        for (int i = 0; i < lines.size(); ++i) {
            BlocLines ext1 = lines.subList(i, i + 1);
            if (cmd2.isValid(ext1) != CommandControl.OK_PARTIAL) continue;
            i = this.tryMultilines(cmd2, i, lines);
        }
    }

    private int tryMultilines(CommandStyleMultilines cmd2, int i, BlocLines lines) {
        for (int j = i + 1; j <= lines.size(); ++j) {
            BlocLines ext1 = lines.subList(i, j);
            if (cmd2.isValid(ext1) == CommandControl.OK) {
                Style newStyle = cmd2.getDeclaredStyle(ext1, this.result);
                this.result.put(newStyle.getStyleName(), newStyle);
                return j;
            }
            if (cmd2.isValid(ext1) != CommandControl.NOT_OK) continue;
            return j;
        }
        return i;
    }
}

