/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.acceptance.ParityAcceptance;

public final class ParityUtil {
    private ParityUtil() {
    }

    public static <S> Automaton<S, ? extends ParityAcceptance> convert(Automaton<S, ? extends ParityAcceptance> automaton, ParityAcceptance.Parity toParity) {
        int colours;
        if (automaton.acceptance().parity() == toParity) {
            return automaton;
        }
        MutableAutomaton<Object, ParityAcceptance> mutableAutomaton = MutableAutomatonUtil.asMutable(automaton);
        Preconditions.checkArgument((boolean)mutableAutomaton.is(Automaton.Property.COMPLETE));
        mutableAutomaton.updateAcceptance(x -> x.withAcceptanceSets(Math.max(3, x.acceptanceSets())));
        ParityAcceptance fromAcceptance = (ParityAcceptance)mutableAutomaton.acceptance();
        if (fromAcceptance.parity().max()) {
            colours = fromAcceptance.acceptanceSets();
            mutableAutomaton.acceptance(fromAcceptance.withAcceptanceSets(colours + 2));
            mutableAutomaton.updateEdges((state, edge) -> edge.withAcceptance(edge.colours().last().orElse(-1) + 2));
        } else {
            colours = fromAcceptance.acceptanceSets();
            mutableAutomaton.acceptance(fromAcceptance.withAcceptanceSets(colours + 2));
            mutableAutomaton.updateEdges((state, edge) -> edge.withAcceptance(edge.colours().first().orElse(colours - 2) + 2));
        }
        fromAcceptance = (ParityAcceptance)mutableAutomaton.acceptance();
        if (fromAcceptance.parity().max() == toParity.max()) {
            assert (fromAcceptance.parity().even() != toParity.even());
        } else {
            int leastImportantColor;
            int acceptanceSets = fromAcceptance.acceptanceSets();
            int n = leastImportantColor = fromAcceptance.parity().max() ? 0 : acceptanceSets - 1;
            int offset = fromAcceptance.parity().even() == toParity.even() ? (fromAcceptance.isAccepting(leastImportantColor) ? 0 : 1) : (fromAcceptance.isAccepting(leastImportantColor) ? -1 : -2);
            int newAcceptanceSets = acceptanceSets + offset;
            IntUnaryOperator mapping = i -> newAcceptanceSets - i;
            throw new UnsupportedOperationException("This combination of options is (currently) unsupported.");
        }
        IntUnaryOperator mapping = i -> i + 1;
        AtomicInteger maximalNewAcceptance = new AtomicInteger(0);
        mutableAutomaton.updateEdges((state, edge) -> {
            int newAcceptance = mapping.applyAsInt(edge.colours().first().orElseThrow());
            if (maximalNewAcceptance.get() < newAcceptance) {
                maximalNewAcceptance.set(newAcceptance);
            }
            return edge.withAcceptance(newAcceptance);
        });
        mutableAutomaton.trim();
        mutableAutomaton.acceptance(new ParityAcceptance(maximalNewAcceptance.get() + 1, toParity));
        return mutableAutomaton;
    }
}

