/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import java.math.BigInteger;
import java.util.BitSet;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface Bdd {
    public int trueNode();

    public int falseNode();

    public int numberOfVariables();

    public int high(int var1);

    public int low(int var1);

    public int variable(int var1);

    public int variableNode(int var1);

    public int createVariable();

    default public int[] createVariables(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be positive");
        }
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = this.createVariable();
        }
        return array;
    }

    public boolean isNodeRoot(int var1);

    public boolean isVariable(int var1);

    public boolean isVariableNegated(int var1);

    public boolean isVariableOrNegated(int var1);

    public int reference(int var1);

    public int dereference(int var1);

    default public void dereference(int ... nodes) {
        for (int node : nodes) {
            this.dereference(node);
        }
    }

    public int getReferenceCount(int var1);

    public boolean evaluate(int var1, boolean[] var2);

    public boolean evaluate(int var1, BitSet var2);

    public BitSet getSatisfyingAssignment(int var1);

    public BigInteger countSatisfyingAssignments(int var1);

    public Iterator<BitSet> solutionIterator(int var1);

    default public void forEachSolution(int node, Consumer<? super BitSet> action) {
        this.solutionIterator(node).forEachRemaining(action);
    }

    default public void forEachPath(int node, Consumer<? super BitSet> action) {
        this.forEachPath(node, (BitSet path, BitSet pathSupport) -> action.accept((BitSet)path));
    }

    default public void forEachPath(int node, BiConsumer<BitSet, BitSet> action) {
        this.forEachPath(node, this.numberOfVariables(), action);
    }

    public void forEachPath(int var1, int var2, BiConsumer<BitSet, BitSet> var3);

    default public BitSet support(int node) {
        return this.support(node, this.numberOfVariables());
    }

    default public BitSet support(int node, int variableCutoff) {
        BitSet bitSet = new BitSet(variableCutoff);
        this.support(node, bitSet, variableCutoff);
        return bitSet;
    }

    default public void support(int node, BitSet bitSet) {
        this.support(node, bitSet, this.numberOfVariables());
    }

    public void support(int var1, BitSet var2, int var3);

    default public int conjunction(int ... variables) {
        if (variables.length == 0) {
            return this.trueNode();
        }
        BitSet variableSet = new BitSet(this.numberOfVariables());
        for (int variable : variables) {
            variableSet.set(variable);
        }
        return this.conjunction(variableSet);
    }

    public int conjunction(BitSet var1);

    default public int disjunction(int ... variables) {
        if (variables.length == 0) {
            return this.falseNode();
        }
        BitSet variableSet = new BitSet(this.numberOfVariables());
        for (int variable : variables) {
            variableSet.set(variable);
        }
        return this.disjunction(variableSet);
    }

    public int disjunction(BitSet var1);

    default public int consume(int result, int inputNode1, int inputNode2) {
        this.reference(result);
        this.dereference(inputNode1);
        this.dereference(inputNode2);
        return result;
    }

    default public int updateWith(int result, int inputNode) {
        this.reference(result);
        this.dereference(inputNode);
        return result;
    }

    public int and(int var1, int var2);

    public int compose(int var1, int[] var2);

    public int equivalence(int var1, int var2);

    public int exists(int var1, BitSet var2);

    public int ifThenElse(int var1, int var2, int var3);

    public int implication(int var1, int var2);

    public boolean implies(int var1, int var2);

    public int not(int var1);

    public int notAnd(int var1, int var2);

    public int or(int var1, int var2);

    public int restrict(int var1, BitSet var2, BitSet var3);

    public int xor(int var1, int var2);

    public String statistics();

    public static final class ReferenceGuard
    implements AutoCloseable {
        private final Bdd bdd;
        private final int node;

        public ReferenceGuard(int node, Bdd bdd) {
            this.node = bdd.reference(node);
            this.bdd = bdd;
        }

        @Override
        public void close() {
            this.bdd.dereference(this.node);
        }

        public Bdd getBdd() {
            return this.bdd;
        }

        public int getNode() {
            return this.node;
        }
    }
}

