/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.AbstractImmutableAutomaton;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.ValuationTree;
import owl.factories.Factories;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.SyntacticFragments;
import owl.ltl.visitors.PropositionalVisitor;
import owl.run.Environment;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.LegacyFactory;
import owl.translations.canonical.RoundRobinState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.AsymmetricProductState;
import owl.translations.mastertheorem.AsymmetricEvaluatedFixpoints;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Predicates;
import owl.translations.mastertheorem.Rewriter;
import owl.translations.mastertheorem.Selector;

public final class AsymmetricLDBAConstruction<B extends GeneralizedBuchiAcceptance>
implements Function<LabelledFormula, AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, B, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>>> {
    private final Environment environment;
    private final Class<? extends B> acceptanceClass;

    private AsymmetricLDBAConstruction(Environment environment, Class<? extends B> acceptanceClass) {
        this.environment = environment;
        this.acceptanceClass = acceptanceClass;
        assert (BuchiAcceptance.class.equals(acceptanceClass) || GeneralizedBuchiAcceptance.class.equals(acceptanceClass));
    }

    public static <B extends GeneralizedBuchiAcceptance> AsymmetricLDBAConstruction<B> of(Environment environment, Class<? extends B> clazz) {
        return new AsymmetricLDBAConstruction<B>(environment, clazz);
    }

    @Override
    public AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, B, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>> apply(LabelledFormula input) {
        Set<Object> blockingModalOperators;
        LabelledFormula formula = input.nnf();
        Factories factories = this.environment.factorySupplier().getFactories(formula.atomicPropositions());
        EquivalenceClass formulaClass = factories.eqFactory.of(formula.formula());
        int acceptanceSets = 1;
        TreeSet<Fixpoints> knownFixpoints = new TreeSet<Fixpoints>();
        HashMap<Fixpoints, AsymmetricEvaluatedFixpoints> evaluationMap = new HashMap<Fixpoints, AsymmetricEvaluatedFixpoints>();
        HashMap<AsymmetricEvaluatedFixpoints, AsymmetricEvaluatedFixpoints.DeterministicAutomata> automataMap = new HashMap<AsymmetricEvaluatedFixpoints, AsymmetricEvaluatedFixpoints.DeterministicAutomata>();
        if (SyntacticFragments.isSafety(formulaClass) || SyntacticFragments.isCoSafety(formulaClass)) {
            blockingModalOperators = Set.of();
        } else {
            for (Fixpoints fixpoints : Selector.selectAsymmetric(formula.formula(), false)) {
                Fixpoints simplified = fixpoints.simplified();
                if (fixpoints.greatestFixpoints().isEmpty()) continue;
                if (evaluationMap.containsKey(simplified)) {
                    knownFixpoints.add(fixpoints);
                    continue;
                }
                AsymmetricEvaluatedFixpoints evaluatedFixpoints = AsymmetricEvaluatedFixpoints.build(simplified, factories);
                if (evaluatedFixpoints == null) continue;
                knownFixpoints.add(fixpoints);
                evaluationMap.put(simplified, evaluatedFixpoints);
                automataMap.put(evaluatedFixpoints, evaluatedFixpoints.deterministicAutomata(factories, this.acceptanceClass.equals(GeneralizedBuchiAcceptance.class)));
            }
            blockingModalOperators = formula.formula().accept(BlockingModalOperatorsVisitor.INSTANCE).stream().filter(x -> !AsymmetricLDBAConstruction.isProperSubformula(x, formulaClass.temporalOperators())).collect(Collectors.toUnmodifiableSet());
            if (this.acceptanceClass.equals(GeneralizedBuchiAcceptance.class)) {
                for (AsymmetricEvaluatedFixpoints.DeterministicAutomata automata : automataMap.values()) {
                    acceptanceSets = Math.max(acceptanceSets, AsymmetricLDBAConstruction.acceptanceSets(automata));
                }
            }
        }
        AcceptingComponentBuilder acceptingComponentBuilder = new AcceptingComponentBuilder(factories, acceptanceSets);
        EquivalenceClass initialState = factories.eqFactory.of(formula.formula()).unfold();
        HashMap jumps = new HashMap();
        Consumer<EquivalenceClass> jumpGenerator = x -> {
            if (SyntacticFragments.isCoSafety(x) || SyntacticFragments.isSafety(x) || !Collections.disjoint(x.temporalOperators(), blockingModalOperators)) {
                return;
            }
            ArrayList<AsymmetricProductState> productStates = new ArrayList<AsymmetricProductState>();
            HashSet<Formula.TemporalOperator> allModalOperators = new HashSet<Formula.TemporalOperator>();
            for (Formula.TemporalOperator temporalOperator : x.temporalOperators()) {
                allModalOperators.addAll(temporalOperator.subformulas(Predicates.IS_GREATEST_FIXPOINT, Formula.TemporalOperator.class::cast));
            }
            for (Fixpoints fixpoints : knownFixpoints) {
                AsymmetricProductState productState;
                if (!fixpoints.allFixpointsPresent(allModalOperators)) continue;
                Fixpoints simplifiedFixpoints = fixpoints.simplified();
                AsymmetricEvaluatedFixpoints evaluatedFixpoints = (AsymmetricEvaluatedFixpoints)evaluationMap.get(simplifiedFixpoints);
                EquivalenceClass remainder = x.unfold().substitute(new Rewriter.ToCoSafety(simplifiedFixpoints.greatestFixpoints()));
                if (remainder.isFalse()) continue;
                if (evaluatedFixpoints.language().implies(remainder)) {
                    productState = acceptingComponentBuilder.createState(factories.eqFactory.of(BooleanConstant.TRUE), evaluatedFixpoints, (AsymmetricEvaluatedFixpoints.DeterministicAutomata)automataMap.get(evaluatedFixpoints));
                } else {
                    if (AsymmetricLDBAConstruction.dependsOnExternalAtoms(remainder, evaluatedFixpoints)) continue;
                    productState = acceptingComponentBuilder.createState(remainder.unfold(), evaluatedFixpoints, (AsymmetricEvaluatedFixpoints.DeterministicAutomata)automataMap.get(evaluatedFixpoints));
                }
                if (productState.language().isFalse()) continue;
                productStates.add(productState);
            }
            jumps.put(x, Set.copyOf(Collections3.maximalElements(productStates, (x1, y) -> x1.language().implies(y.language()))));
        };
        final DeterministicConstructions.Tracking tracking = new DeterministicConstructions.Tracking(factories);
        final BitSet bitSet = new BitSet();
        bitSet.set(0, acceptanceSets);
        Function<EquivalenceClass, Set> jumpLookup = x -> jumps.getOrDefault(x, Set.of());
        AbstractImmutableAutomaton.NonDeterministicEdgeTreeAutomaton<EquivalenceClass, AllAcceptance> automaton = new AbstractImmutableAutomaton.NonDeterministicEdgeTreeAutomaton<EquivalenceClass, AllAcceptance>(factories.vsFactory, initialState.isFalse() ? Set.of() : Set.of(initialState), AllAcceptance.INSTANCE){

            @Override
            public ValuationTree<Edge<EquivalenceClass>> edgeTree(EquivalenceClass state) {
                return tracking.successorTree(state).map(successors -> {
                    EquivalenceClass successor = (EquivalenceClass)Iterables.getOnlyElement((Iterable)successors);
                    if (successor.isFalse()) {
                        return Set.of();
                    }
                    return Set.of(SyntacticFragments.isSafety(successor) ? Edge.of(successor, bitSet) : Edge.of(successor));
                });
            }
        };
        HashMapAutomaton<EquivalenceClass, AllAcceptance> initialComponent = HashMapAutomaton.copyOf(automaton);
        assert (initialComponent.is(Automaton.Property.DETERMINISTIC));
        initialComponent.states().forEach(jumpGenerator);
        initialComponent.name("LTL to LDBA (asymmetric) for formula: " + formula);
        return AnnotatedLDBA.build(initialComponent, acceptingComponentBuilder, jumpLookup, EquivalenceClass::language, new TreeSet(evaluationMap.values()), jumpLookup);
    }

    private static int acceptanceSets(AsymmetricEvaluatedFixpoints.DeterministicAutomata a) {
        return (a.coSafety.isEmpty() && a.fCoSafety.isEmpty() ? 0 : 1) + (a.gfCoSafetyAutomaton == null ? 0 : ((GeneralizedBuchiAcceptance)a.gfCoSafetyAutomaton.acceptance()).acceptanceSets());
    }

    private static boolean dependsOnExternalAtoms(EquivalenceClass remainder, AsymmetricEvaluatedFixpoints obligation) {
        BitSet remainderAP = remainder.atomicPropositions(true);
        BitSet atoms = obligation.language().atomicPropositions(true);
        assert (!remainderAP.isEmpty());
        assert (!atoms.isEmpty());
        return !remainderAP.intersects(atoms);
    }

    private static boolean isProperSubformula(Formula formula, Collection<? extends Formula> set) {
        return set.stream().anyMatch(x -> {
            if (x.equals(formula)) return false;
            if (!x.anyMatch(formula::equals)) return false;
            return true;
        });
    }

    private static final class BlockingModalOperatorsVisitor
    extends PropositionalVisitor<Set<Formula.TemporalOperator>> {
        private static final BlockingModalOperatorsVisitor INSTANCE = new BlockingModalOperatorsVisitor();

        private BlockingModalOperatorsVisitor() {
        }

        @Override
        protected Set<Formula.TemporalOperator> visit(Formula.TemporalOperator formula) {
            if (SyntacticFragments.isFinite(formula)) {
                return Set.of();
            }
            if (SyntacticFragments.isCoSafety(formula)) {
                return Set.of(formula);
            }
            return Set.of();
        }

        @Override
        public Set<Formula.TemporalOperator> visit(Literal literal) {
            return Set.of();
        }

        @Override
        public Set<Formula.TemporalOperator> visit(BooleanConstant booleanConstant) {
            return Set.of();
        }

        @Override
        public Set<Formula.TemporalOperator> visit(Conjunction conjunction) {
            HashSet<Formula.TemporalOperator> blockingOperators = new HashSet<Formula.TemporalOperator>();
            for (Formula child : conjunction.operands) {
                if (SyntacticFragments.isFinite(child)) continue;
                blockingOperators.addAll((Collection<Formula.TemporalOperator>)child.accept(this));
            }
            return blockingOperators;
        }

        @Override
        public Set<Formula.TemporalOperator> visit(Disjunction disjunction) {
            HashSet blockingOperators = null;
            for (Formula child : disjunction.operands) {
                if (SyntacticFragments.isFinite(child)) continue;
                if (blockingOperators == null) {
                    blockingOperators = new HashSet(child.accept(this));
                    continue;
                }
                blockingOperators.retainAll((Collection)child.accept(this));
            }
            return blockingOperators == null ? Set.of() : blockingOperators;
        }
    }

    final class AcceptingComponentBuilder
    implements AnnotatedLDBA.AcceptingComponentBuilder<AsymmetricProductState, B> {
        final int acceptanceSets;
        final Factories factories;
        final LegacyFactory factory;
        final List<AsymmetricProductState> anchors = new ArrayList<AsymmetricProductState>();

        AcceptingComponentBuilder(Factories factories, int acceptanceSets) {
            this.factories = factories;
            this.factory = new LegacyFactory(factories);
            this.acceptanceSets = acceptanceSets;
        }

        AsymmetricProductState createState(EquivalenceClass remainder, AsymmetricEvaluatedFixpoints evaluatedFixpoints, AsymmetricEvaluatedFixpoints.DeterministicAutomata automata) {
            assert (SyntacticFragments.isCoSafety(remainder));
            EquivalenceClass safety = (EquivalenceClass)automata.safetyAutomaton.onlyInitialState();
            EquivalenceClass current = remainder;
            if (SyntacticFragments.isSafety(remainder)) {
                safety = current.and(safety);
                current = this.factories.eqFactory.of(BooleanConstant.TRUE);
            } else {
                current = this.factory.initialStateInternal(current, safety.and(evaluatedFixpoints.language()).unfold());
            }
            if (automata.coSafety.isEmpty() && automata.fCoSafety.isEmpty()) {
                return new AsymmetricProductState(0, safety, current, List.of(), evaluatedFixpoints, automata);
            }
            EquivalenceClass[] nextCoSafety = new EquivalenceClass[automata.coSafety.size()];
            for (int i = 0; i < nextCoSafety.length; ++i) {
                nextCoSafety[i] = this.factory.initialStateInternal(automata.coSafety.get(i), current);
            }
            if (current.isTrue()) {
                if (automata.coSafety.isEmpty()) {
                    current = this.factory.initialStateInternal(automata.fCoSafety.get(0), safety);
                } else {
                    current = this.factory.initialStateInternal(nextCoSafety[0], safety);
                    nextCoSafety[0] = this.factories.eqFactory.of(BooleanConstant.TRUE);
                }
            }
            int index = automata.coSafety.isEmpty() ? -automata.fCoSafety.size() : 0;
            return new AsymmetricProductState(index, safety, current, List.of(nextCoSafety), evaluatedFixpoints, automata);
        }

        @Override
        public void addInitialStates(Collection<? extends AsymmetricProductState> initialStates) {
            this.anchors.addAll(List.copyOf(initialStates));
        }

        @Override
        public MutableAutomaton<AsymmetricProductState, B> build() {
            return HashMapAutomaton.of((GeneralizedBuchiAcceptance)AsymmetricLDBAConstruction.this.acceptanceClass.cast(GeneralizedBuchiAcceptance.of(this.acceptanceSets)), this.factories.vsFactory, this.anchors, this::edge, state -> {
                BitSet sensitiveAlphabet = state.currentCoSafety.atomicPropositions();
                sensitiveAlphabet.or(state.safety.atomicPropositions());
                for (EquivalenceClass clazz : state.nextCoSafety) {
                    sensitiveAlphabet.or(clazz.atomicPropositions());
                }
                for (EquivalenceClass clazz : state.automata.fCoSafety) {
                    sensitiveAlphabet.or(clazz.atomicPropositions());
                }
                sensitiveAlphabet.or(state.evaluatedFixpoints.language().atomicPropositions(true));
                return sensitiveAlphabet;
            });
        }

        @Nullable
        private Edge<AsymmetricProductState> edge(AsymmetricProductState state, BitSet valuation) {
            int usedAcceptanceSets;
            int j;
            AsymmetricEvaluatedFixpoints.DeterministicAutomata automata = state.automata;
            EquivalenceClass safetySuccessor = automata.safetyAutomaton.successor(state.safety, valuation);
            if (safetySuccessor == null) {
                return null;
            }
            EquivalenceClass currentCoSafetySuccessor = this.factory.successor(state.currentCoSafety, valuation, safetySuccessor);
            EquivalenceClass assumptions = currentCoSafetySuccessor.and(safetySuccessor);
            List<EquivalenceClass> nextSuccessors = state.nextCoSafety.stream().map(x -> this.factory.successor((EquivalenceClass)x, valuation, assumptions)).collect(Collectors.toList());
            boolean acceptingEdge = false;
            boolean currentSuccessful = false;
            if (currentCoSafetySuccessor.isTrue()) {
                currentSuccessful = true;
                j = this.scan(state.index + 1, nextSuccessors, valuation, assumptions, automata);
                if (j >= automata.coSafety.size()) {
                    acceptingEdge = true;
                    j = this.scan(-automata.fCoSafety.size(), nextSuccessors, valuation, assumptions, automata);
                    if (j >= automata.coSafety.size()) {
                        j = -automata.fCoSafety.size();
                    }
                }
                if (j < 0) {
                    currentCoSafetySuccessor = this.factory.initialStateInternal(automata.fCoSafety.get(automata.fCoSafety.size() + j), assumptions);
                } else if (!nextSuccessors.isEmpty()) {
                    currentCoSafetySuccessor = nextSuccessors.get(j).and(this.factory.initialStateInternal(automata.coSafety.get(j), assumptions));
                }
            } else {
                j = state.index;
            }
            for (int i = 0; i < nextSuccessors.size(); ++i) {
                if (currentSuccessful && i == j) {
                    nextSuccessors.set(i, this.factories.eqFactory.of(BooleanConstant.TRUE));
                    continue;
                }
                nextSuccessors.set(i, nextSuccessors.get(i).and(this.factory.initialStateInternal(automata.coSafety.get(i), assumptions)));
            }
            AsymmetricProductState successor = new AsymmetricProductState(j, safetySuccessor, currentCoSafetySuccessor, nextSuccessors, state.evaluatedFixpoints, automata);
            if (successor.language().isFalse()) {
                return null;
            }
            BitSet acceptance = new BitSet();
            if (acceptingEdge) {
                acceptance.set(0);
            }
            if (automata.gfCoSafetyAutomaton != null) {
                assert (AsymmetricLDBAConstruction.this.acceptanceClass.equals(GeneralizedBuchiAcceptance.class));
                DeterministicConstructions.GfCoSafety automaton = automata.gfCoSafetyAutomaton;
                Edge<RoundRobinState<EquivalenceClass>> edge = automaton.edge((RoundRobinState)automaton.onlyInitialState(), valuation);
                assert (edge.successor().equals(automaton.onlyInitialState()));
                edge.acceptanceSetIterator().forEachRemaining(x -> acceptance.set(x + 1));
            }
            if ((usedAcceptanceSets = AsymmetricLDBAConstruction.acceptanceSets(automata)) != 0 || successor.currentCoSafety.isTrue()) {
                acceptance.set(usedAcceptanceSets, this.acceptanceSets);
            }
            return Edge.of(successor, acceptance);
        }

        private int scan(int index, List<EquivalenceClass> nextCoSafety, BitSet valuation, EquivalenceClass environment, AsymmetricEvaluatedFixpoints.DeterministicAutomata automata) {
            int i;
            for (i = index; i < 0; ++i) {
                EquivalenceClass successor = this.factory.successor(automata.fCoSafety.get(automata.fCoSafety.size() + i), valuation, environment);
                if (successor.isTrue()) continue;
                return i;
            }
            while (i < nextCoSafety.size() && nextCoSafety.get(i).isTrue()) {
                ++i;
            }
            return i;
        }
    }
}

