/*
 * Decompiled with CFR 0.152.
 */
package owl.run.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import owl.run.Environment;
import owl.run.Pipeline;
import owl.run.RunUtil;
import owl.run.modules.OwlModule;
import owl.run.modules.OwlModuleRegistry;
import owl.run.parser.ParseUtil;
import owl.run.parser.PipelineParser;

public final class OwlParser {
    private static final Logger logger = Logger.getLogger(PipelineParser.class.getName());
    public final Pipeline pipeline;
    public final CommandLine globalSettings;

    public OwlParser(Pipeline pipeline, CommandLine globalSettings) {
        this.pipeline = pipeline;
        this.globalSettings = globalSettings;
    }

    @Nullable
    public static OwlParser parse(String[] arguments, CommandLineParser cliParser, Options globalOptions, OwlModuleRegistry registry) {
        Pipeline pipeline;
        CommandLine globalSettings;
        RunUtil.checkForVersion(arguments);
        logger.log(Level.FINE, "Parsing arguments list {0}", Arrays.toString(arguments));
        if (arguments.length == 0 || ParseUtil.isHelp(arguments)) {
            ParseUtil.println("This is owl. Owl is a flexible tool for various translations involving automata. To allow for great flexibility and rapid prototyping, it was equipped with a very flexible module-based command line interface. You can specify a specific translation in the following way:\n\n  owl <settings> <input parser> --- <multiple modules> --- <output>\n\nAvailable settings for registered modules are printed below");
            ParseUtil.printHelp("Global settings:", globalOptions);
            ParseUtil.println();
            ParseUtil.printList(ParseUtil.getSortedSettings(registry, OwlModuleRegistry.Type.READER), OwlModuleRegistry.Type.READER, null);
            ParseUtil.println();
            ParseUtil.printList(ParseUtil.getSortedSettings(registry, OwlModuleRegistry.Type.TRANSFORMER), OwlModuleRegistry.Type.TRANSFORMER, null);
            ParseUtil.println();
            ParseUtil.printList(ParseUtil.getSortedSettings(registry, OwlModuleRegistry.Type.WRITER), OwlModuleRegistry.Type.WRITER, null);
            return null;
        }
        String specificHelp = ParseUtil.isSpecificHelp(arguments);
        if (specificHelp != null) {
            Map<OwlModuleRegistry.Type, OwlModule<?>> modules = registry.get(specificHelp);
            if (modules.isEmpty()) {
                throw RunUtil.failWithMessage("No module found for name " + specificHelp);
            }
            modules.forEach((type, module) -> {
                ParseUtil.printModuleHelp(module, null);
                ParseUtil.println();
            });
            return null;
        }
        try {
            globalSettings = cliParser.parse(globalOptions, arguments, true);
        }
        catch (ParseException e) {
            ParseUtil.printHelp("global", globalOptions, e.getMessage());
            return null;
        }
        Environment environment = OwlParser.getEnvironment(globalSettings);
        List<PipelineParser.ModuleDescription> split = PipelineParser.split(globalSettings.getArgList(), "---"::equals);
        try {
            pipeline = PipelineParser.parse(split, cliParser, registry, environment);
        }
        catch (OwlModuleRegistry.OwlModuleNotFoundException e) {
            ParseUtil.printList(registry.get(e.type), e.type, e.name);
            return null;
        }
        catch (PipelineParser.ModuleParseException e) {
            ParseUtil.printModuleHelp(e.settings, e.getMessage());
            return null;
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            return null;
        }
        globalSettings.getArgList().clear();
        return new OwlParser(pipeline, globalSettings);
    }

    public static Environment getEnvironment(CommandLine globalSettings) {
        return Environment.of(globalSettings.hasOption(RunUtil.getDefaultAnnotationOption().getOpt()));
    }
}

