/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.tum.in.naturals.bitset.BitSets;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.EdgeMapAutomatonMixin;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;

public final class HashMapAutomaton<S, A extends OmegaAcceptance>
implements EdgeMapAutomatonMixin<S, A>,
MutableAutomaton<S, A> {
    private static final Logger logger = Logger.getLogger(HashMapAutomaton.class.getName());
    private A acceptance;
    private final Set<S> initialStates;
    private IdentityHashMap<S, Map<Edge<S>, ValuationSet>> transitions;
    private final IdentityHashMap<S, ValuationTree<Edge<S>>> cachedTrees;
    private Map<S, S> uniqueStates;
    private final ValuationSetFactory valuationSetFactory;
    @Nullable
    private String name;
    private State state = State.READ;

    HashMapAutomaton(ValuationSetFactory valuationSetFactory, A acceptance) {
        this.valuationSetFactory = valuationSetFactory;
        this.acceptance = acceptance;
        this.transitions = new IdentityHashMap();
        this.cachedTrees = new IdentityHashMap();
        this.uniqueStates = new HashMap<S, S>();
        this.initialStates = new HashSet<S>();
    }

    @Override
    public A acceptance() {
        return this.acceptance;
    }

    @Override
    public void acceptance(A acceptance) {
        this.acceptance = acceptance;
    }

    @Override
    public Set<S> initialStates() {
        this.readMode();
        return Collections.unmodifiableSet(this.initialStates);
    }

    @Override
    public void initialStates(Collection<? extends S> initialStates) {
        this.writeMode();
        if (!initialStates.containsAll(this.initialStates)) {
            this.state = State.WRITE_REBUILD;
            this.initialStates.clear();
        }
        initialStates.forEach(this::addInitialState);
    }

    @Override
    public void addInitialState(S initialState) {
        this.initialStates.add(this.makeUnique(initialState));
    }

    @Override
    public void removeInitialState(S initialState) {
        this.state = State.WRITE_REBUILD;
        this.initialStates.remove(initialState);
    }

    @Override
    public Set<S> states() {
        this.readMode();
        return Collections.unmodifiableSet(this.uniqueStates.keySet());
    }

    @Override
    public void addState(S state) {
        this.writeMode();
        if (!this.uniqueStates.containsKey(state)) {
            this.state = State.WRITE_REBUILD;
            this.makeUnique(state);
        }
    }

    @Override
    public void removeStateIf(Predicate<? super S> stateFilter) {
        this.writeMode();
        if (!this.uniqueStates.keySet().removeIf(stateFilter)) {
            return;
        }
        this.state = State.WRITE_REBUILD;
        this.initialStates.removeIf(stateFilter);
        Predicate<Edge> edgeFilter = edge -> stateFilter.test((Object)edge.successor());
        this.transitions.entrySet().removeIf(entry -> {
            boolean removeState = stateFilter.test((Object)entry.getKey());
            if (!removeState) {
                ((Map)entry.getValue()).keySet().removeIf(edgeFilter);
            }
            return removeState;
        });
    }

    @Override
    @Nullable
    public Edge<S> edge(S state, BitSet valuation) {
        this.readMode();
        for (Map.Entry<Edge<S>, ValuationSet> entry : this.edgeMapInternal(state).entrySet()) {
            if (!entry.getValue().contains(valuation)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Set<Edge<S>> edges(S state) {
        this.readMode();
        return Collections.unmodifiableSet(this.edgeMapInternal(state).keySet());
    }

    @Override
    public Map<Edge<S>, ValuationSet> edgeMap(S state) {
        this.readMode();
        return Collections.unmodifiableMap(this.edgeMapInternal(state));
    }

    @Override
    public ValuationTree<Edge<S>> edgeTree(S state) {
        this.readMode();
        S uniqueState = this.uniqueStates.get(Objects.requireNonNull(state));
        return this.cachedTrees.computeIfAbsent(uniqueState, x -> this.factory().inverse(this.edgeMap(x)));
    }

    @Override
    public Set<S> successors(S state) {
        this.readMode();
        return Edges.successors(this.edgeMapInternal(state).keySet());
    }

    @Override
    public void addEdge(S source, ValuationSet valuations, Edge<? extends S> edge) {
        this.edgeMapInternal(source).merge(this.makeUnique(edge), valuations, ValuationSet::union);
    }

    @Override
    public void removeEdge(S source, ValuationSet valuations, S destination) {
        this.writeMode();
        ValuationSet complement = valuations.complement();
        boolean edgeRemoved = this.edgeMapInternal(source).entrySet().removeIf(entry -> {
            if (!destination.equals(((Edge)entry.getKey()).successor())) {
                return false;
            }
            ValuationSet edgeValuation = ((ValuationSet)entry.getValue()).intersection(complement);
            entry.setValue(edgeValuation);
            return edgeValuation.isEmpty();
        });
        if (!source.equals(destination) && edgeRemoved) {
            this.state = State.WRITE_REBUILD;
        }
    }

    @Override
    public void updateEdges(Set<? extends S> states, BiFunction<? super S, Edge<S>, Edge<S>> f) {
        this.writeMode();
        for (S state : states) {
            Map map = this.edgeMapInternal(state);
            HashMap<Edge, ValuationSet> secondMap = new HashMap<Edge, ValuationSet>();
            map.entrySet().removeIf(entry -> {
                Edge oldEdge = (Edge)entry.getKey();
                Edge<S> newEdge = (Edge<S>)f.apply((S)state, oldEdge);
                if (newEdge == null) {
                    if (!state.equals(oldEdge.successor())) {
                        this.state = State.WRITE_REBUILD;
                    }
                    return true;
                }
                if (oldEdge.equals(newEdge)) {
                    return false;
                }
                if (!oldEdge.successor().equals(newEdge.successor())) {
                    this.state = State.WRITE_REBUILD;
                }
                newEdge = this.makeUnique(newEdge);
                secondMap.merge(newEdge, (ValuationSet)entry.getValue(), ValuationSet::union);
                return true;
            });
            secondMap.forEach((edge, valuations) -> map.merge((Edge)edge, (ValuationSet)valuations, ValuationSet::union));
        }
    }

    @Override
    public void updateEdges(BiFunction<S, Edge<S>, Edge<S>> updater) {
        this.updateEdges(this.transitions.keySet(), updater);
    }

    @Override
    public void accept(Automaton.EdgeVisitor<S> visitor) {
        this.readMode();
        this.transitions.forEach((state, edges) -> {
            visitor.enter(state);
            edges.forEach((edge, valuations) -> valuations.forEach(valuation -> visitor.visit((Object)state, (BitSet)valuation, (Edge)edge)));
            visitor.exit(state);
        });
    }

    @Override
    public void accept(Automaton.EdgeMapVisitor<S> visitor) {
        this.readMode();
        this.transitions.forEach((state, edges) -> {
            visitor.enter(state);
            visitor.visit(state, Collections.unmodifiableMap(edges));
            visitor.exit(state);
        });
    }

    @Override
    public void accept(Automaton.EdgeTreeVisitor<S> visitor) {
        this.readMode();
        this.transitions.forEach((state, edges) -> {
            visitor.enter(state);
            visitor.visit(state, this.factory().inverse(edges));
            visitor.exit(state);
        });
    }

    @Override
    public ValuationSetFactory factory() {
        return this.valuationSetFactory;
    }

    @Override
    public String name() {
        return this.name == null ? String.format("Automaton for %s", this.initialStates()) : this.name;
    }

    @Override
    public void name(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    @Override
    public void trim() {
        this.cachedTrees.clear();
        if (this.state != State.WRITE_REBUILD) {
            this.state = State.READ;
            return;
        }
        this.state = State.READ;
        HashSet<S> exploredStates = new HashSet<S>(this.initialStates());
        ArrayDeque<S> workQueue = new ArrayDeque<S>(exploredStates);
        IdentityHashMap<S, Map<Edge<S>, ValuationSet>> oldTransitions = this.transitions;
        this.transitions = new IdentityHashMap(oldTransitions.size());
        this.uniqueStates = new HashMap<S, S>(this.uniqueStates.size());
        this.initialStates.forEach(this::makeUnique);
        while (!workQueue.isEmpty()) {
            Object state = workQueue.remove();
            ((Map)oldTransitions.get(state)).forEach((edge, valuationSet) -> {
                this.addEdge((S)state, (ValuationSet)valuationSet, (Edge<? extends S>)edge);
                if (exploredStates.add(edge.successor())) {
                    workQueue.add(edge.successor());
                }
            });
        }
        logger.log(Level.FINEST, "Cleared {0} states", oldTransitions.size() - this.transitions.size());
        Verify.verify((this.state == State.READ ? 1 : 0) != 0, (String)"Concurrent modification.", (Object[])new Object[0]);
    }

    @VisibleForTesting
    boolean checkConsistency() {
        Preconditions.checkState((boolean)this.transitions.keySet().containsAll(this.initialStates));
        Preconditions.checkState((boolean)this.transitions.keySet().equals(this.uniqueStates.keySet()));
        HashMultimap successors = HashMultimap.create();
        HashMultimap predecessors = HashMultimap.create();
        this.transitions.forEach((arg_0, arg_1) -> this.lambda$checkConsistency$12((Multimap)successors, (Multimap)predecessors, arg_0, arg_1));
        return true;
    }

    private void readMode() {
        Preconditions.checkState((this.state == State.READ ? 1 : 0) != 0, (Object)"trim() must be called.");
    }

    private void writeMode() {
        if (this.state == State.READ) {
            this.state = State.WRITE;
        }
    }

    private Map<Edge<S>, ValuationSet> edgeMapInternal(S state) {
        S uniqueState = this.uniqueStates.get(Objects.requireNonNull(state));
        Preconditions.checkArgument((uniqueState != null ? 1 : 0) != 0, (String)"State %s not in automaton", state);
        Map<Edge<S>, ValuationSet> successors = this.transitions.get(uniqueState);
        assert (successors.values().stream().noneMatch(ValuationSet::isEmpty));
        return successors;
    }

    private S makeUnique(S state) {
        Objects.requireNonNull(state);
        S uniqueState = this.uniqueStates.putIfAbsent(state, state);
        if (uniqueState == null) {
            this.transitions.put(state, new LinkedHashMap());
            return state;
        }
        assert (this.transitions.containsKey(uniqueState)) : String.format("Inconsistent mapping for %s", uniqueState);
        return uniqueState;
    }

    private Edge<S> makeUnique(Edge<? extends S> edge) {
        S successor = edge.successor();
        S uniqueSuccessor = this.makeUnique(successor);
        Edge<S> castedEdge = edge;
        return successor == uniqueSuccessor ? castedEdge : castedEdge.withSuccessor(uniqueSuccessor);
    }

    public static <S, A extends OmegaAcceptance> HashMapAutomaton<S, A> of(A acceptance, ValuationSetFactory vsFactory) {
        return new HashMapAutomaton<S, A>(vsFactory, acceptance);
    }

    public static <S, A extends OmegaAcceptance> HashMapAutomaton<S, A> of(A acceptance, ValuationSetFactory vsFactory, Collection<S> initialStates, BiFunction<S, BitSet, Edge<S>> successors, Function<S, BitSet> alphabet) {
        HashMapAutomaton automaton = new HashMapAutomaton(vsFactory, acceptance);
        initialStates.forEach(automaton::addInitialState);
        HashSet<S> exploredStates = new HashSet<S>(initialStates);
        ArrayDeque<S> workQueue = new ArrayDeque<S>(exploredStates);
        int alphabetSize = vsFactory.atomicPropositions().size();
        while (!workQueue.isEmpty()) {
            Object state = workQueue.remove();
            BitSet sensitiveAlphabet = alphabet.apply(state);
            Set bitSets = sensitiveAlphabet == null ? BitSets.powerSet((int)alphabetSize) : BitSets.powerSet((BitSet)sensitiveAlphabet);
            for (BitSet valuation : bitSets) {
                Edge<S> edge = successors.apply(state, valuation);
                if (edge == null) continue;
                ValuationSet valuationSet = sensitiveAlphabet == null ? vsFactory.of(valuation) : vsFactory.of(valuation, sensitiveAlphabet);
                S successorState = edge.successor();
                if (exploredStates.add(successorState)) {
                    workQueue.add(successorState);
                }
                automaton.addEdge(state, valuationSet, edge);
            }
        }
        return automaton;
    }

    public static <S, A extends OmegaAcceptance> HashMapAutomaton<S, A> copyOf(Automaton<S, A> source) {
        HashMapAutomaton<S, A> target = new HashMapAutomaton<S, A>(source.factory(), source.acceptance());
        source.initialStates().forEach(target::addInitialState);
        MutableAutomatonUtil.copyInto(source, target);
        target.trim();
        target.name(source.name());
        assert (source.states().equals(target.states()));
        return target;
    }

    private /* synthetic */ void lambda$checkConsistency$12(Multimap successors, Multimap predecessors, Object state, Map edges) {
        Set successorStates = Edges.successors(edges.keySet());
        Preconditions.checkState((boolean)this.transitions.keySet().containsAll(successorStates));
        successors.putAll(state, successorStates);
        for (Object successor : successorStates) {
            predecessors.put(successor, state);
        }
    }

    private static enum State {
        READ,
        WRITE,
        WRITE_REBUILD;

    }
}

