/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.extensions.BooleanExpressions;
import owl.automaton.AbstractImmutableAutomaton;
import owl.automaton.Automaton;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedCoBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.NullablePair;
import owl.collections.Pair;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.collections.ValuationTrees;
import owl.factories.ValuationSetFactory;

public final class BooleanOperations {
    private BooleanOperations() {
    }

    @Deprecated
    public static <S> Automaton<List<S>, BuchiAcceptance> unionBuchi(List<Automaton<S, BuchiAcceptance>> automata) {
        Preconditions.checkArgument((!automata.isEmpty() ? 1 : 0) != 0, (Object)"No automaton was passed.");
        assert (automata.stream().allMatch(x -> x.is(Automaton.Property.DETERMINISTIC)));
        ValuationSetFactory factory = BooleanOperations.commonAlphabet(automata.stream().map(Automaton::factory).collect(Collectors.toList()), true).fst();
        final ArrayList<Automaton<S, BuchiAcceptance>> buchi = new ArrayList<Automaton<S, BuchiAcceptance>>(automata);
        return new AbstractImmutableAutomaton.SemiDeterministicEdgesAutomaton<List<S>, BuchiAcceptance>(factory, Set.of(buchi.stream().map(Automaton::onlyInitialState).collect(Collectors.toUnmodifiableList())), BuchiAcceptance.INSTANCE){

            @Override
            public Edge<List<S>> edge(List<S> productState, BitSet valuation) {
                ArrayList productSuccessor = new ArrayList(productState.size());
                BitSet acceptanceSets = new BitSet();
                for (int i = 0; i < productState.size(); ++i) {
                    Object state = productState.get(i);
                    if (state == null) {
                        productSuccessor.add(null);
                        continue;
                    }
                    Edge edge = ((Automaton)buchi.get(i)).edge(state, valuation);
                    if (edge == null) {
                        productSuccessor.add(null);
                        continue;
                    }
                    productSuccessor.add(edge.successor());
                    assert (edge.largestAcceptanceSet() <= 0);
                    if (!edge.hasAcceptanceSets()) continue;
                    acceptanceSets.set(0);
                }
                productSuccessor.trimToSize();
                return Edge.of(Collections.unmodifiableList(productSuccessor), acceptanceSets);
            }
        };
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> deterministicComplement(Automaton<S, ?> automaton, @Nullable S trapState, Class<A> expectedAcceptance) {
        Automaton<S, ?> completeAutomaton = trapState == null ? automaton : Views.complete(automaton, trapState);
        Preconditions.checkArgument((boolean)completeAutomaton.is(Automaton.Property.COMPLETE), (Object)"Automaton is not complete.");
        Preconditions.checkArgument((!completeAutomaton.initialStates().isEmpty() ? 1 : 0) != 0, (Object)"Automaton is empty.");
        Object acceptance = completeAutomaton.acceptance();
        OmegaAcceptance complementAcceptance = null;
        if (acceptance instanceof BuchiAcceptance) {
            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(CoBuchiAcceptance.class, expectedAcceptance));
            complementAcceptance = CoBuchiAcceptance.INSTANCE;
        } else if (acceptance instanceof CoBuchiAcceptance) {
            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(BuchiAcceptance.class, expectedAcceptance));
            complementAcceptance = BuchiAcceptance.INSTANCE;
        } else if (acceptance instanceof GeneralizedBuchiAcceptance) {
            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(GeneralizedCoBuchiAcceptance.class, expectedAcceptance));
            GeneralizedBuchiAcceptance castedAcceptance = (GeneralizedBuchiAcceptance)acceptance;
            complementAcceptance = GeneralizedCoBuchiAcceptance.of(castedAcceptance.size);
        } else if (acceptance instanceof GeneralizedCoBuchiAcceptance) {
            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(GeneralizedBuchiAcceptance.class, expectedAcceptance));
            GeneralizedCoBuchiAcceptance castedAcceptance = (GeneralizedCoBuchiAcceptance)acceptance;
            complementAcceptance = GeneralizedBuchiAcceptance.of(castedAcceptance.size);
        } else if (acceptance instanceof ParityAcceptance) {
            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(ParityAcceptance.class, expectedAcceptance));
            complementAcceptance = ((ParityAcceptance)automaton.acceptance()).complement();
        }
        if (complementAcceptance == null) {
            throw new UnsupportedOperationException("Cannot complement to " + expectedAcceptance);
        }
        return OmegaAcceptanceCast.cast(new ReplacedAcceptanceConditionView<S, CoBuchiAcceptance>(completeAutomaton, (CoBuchiAcceptance)complementAcceptance), expectedAcceptance);
    }

    public static <S1, S2> Automaton<Pair<S1, S2>, ?> intersection(Automaton<S1, ?> automaton1, Automaton<S2, ?> automaton2) {
        return BooleanOperations.intersection(automaton1, automaton2, false);
    }

    public static <S1, S2> Automaton<Pair<S1, S2>, ?> intersection(Automaton<S1, ?> automaton1, Automaton<S2, ?> automaton2, boolean ignoreSymbolicFactoryMismatch) {
        Pair<ValuationSetFactory, Boolean> factory = BooleanOperations.commonAlphabet(List.of(automaton1.factory(), automaton2.factory()), ignoreSymbolicFactoryMismatch);
        PairIntersectionAutomaton<S1, S2> intersection = new PairIntersectionAutomaton<S1, S2>(automaton1, automaton2, factory);
        return OmegaAcceptanceCast.castHeuristically(intersection);
    }

    public static <S> Automaton<List<S>, ?> intersection(List<Automaton<S, ?>> automata) {
        return BooleanOperations.intersection(automata, false);
    }

    public static <S> Automaton<List<S>, ?> intersection(List<Automaton<S, ?>> automata, boolean ignoreSymbolicFactoryMismatch) {
        Preconditions.checkArgument((!automata.isEmpty() ? 1 : 0) != 0, (Object)"Automata is empty.");
        Pair<ValuationSetFactory, Boolean> factory = BooleanOperations.commonAlphabet(automata, ignoreSymbolicFactoryMismatch);
        ListIntersectionAutomaton<S> intersection = new ListIntersectionAutomaton<S>(automata, factory);
        return OmegaAcceptanceCast.castHeuristically(intersection);
    }

    public static <S1, S2> Automaton<NullablePair<S1, S2>, ?> deterministicUnion(Automaton<S1, ?> automaton1, Automaton<S2, ?> automaton2) {
        return BooleanOperations.deterministicUnion(automaton1, automaton2, false);
    }

    public static <S1, S2> Automaton<NullablePair<S1, S2>, ?> deterministicUnion(Automaton<S1, ?> automaton1, Automaton<S2, ?> automaton2, boolean ignoreSymbolicFactoryMismatch) {
        Pair<ValuationSetFactory, Boolean> factory = BooleanOperations.commonAlphabet(List.of(automaton1.factory(), automaton2.factory()), ignoreSymbolicFactoryMismatch);
        NullablePairDeterministicUnionAutomaton<S1, S2> union = new NullablePairDeterministicUnionAutomaton<S1, S2>(automaton1, automaton2, factory);
        return OmegaAcceptanceCast.castHeuristically(union);
    }

    public static <S> Automaton<Map<Integer, S>, ?> deterministicUnion(List<Automaton<S, ?>> automata) {
        return BooleanOperations.deterministicUnion(automata, false);
    }

    public static <S> Automaton<Map<Integer, S>, ?> deterministicUnion(List<Automaton<S, ?>> automata, boolean ignoreSymbolicFactoryMismatch) {
        Preconditions.checkArgument((!automata.isEmpty() ? 1 : 0) != 0, (Object)"Automata is empty.");
        Pair<ValuationSetFactory, Boolean> factory = BooleanOperations.commonAlphabet(automata, ignoreSymbolicFactoryMismatch);
        MapDeterministicUnionAutomaton<S> union = new MapDeterministicUnionAutomaton<S>(automata, factory);
        return OmegaAcceptanceCast.castHeuristically(union);
    }

    private static <S> Pair<ValuationSetFactory, Boolean> commonAlphabet(List<Automaton<S, ?>> automata, boolean ignoreSymbolicFactoryMismatch) {
        return BooleanOperations.commonAlphabet(automata.stream().map(Automaton::factory).collect(Collectors.toList()), ignoreSymbolicFactoryMismatch);
    }

    private static Pair<ValuationSetFactory, Boolean> commonAlphabet(Iterable<ValuationSetFactory> factories, boolean ignoreSymbolicFactoryMismatch) {
        Iterator<ValuationSetFactory> iterator = factories.iterator();
        ValuationSetFactory factory = iterator.next();
        boolean symbolicOperationsAllowed = true;
        while (iterator.hasNext()) {
            ValuationSetFactory otherFactory = iterator.next();
            boolean bl = symbolicOperationsAllowed = symbolicOperationsAllowed && factory.equals(otherFactory);
            if (!ignoreSymbolicFactoryMismatch && !symbolicOperationsAllowed) {
                throw new IllegalArgumentException("Symbolic factories are incompatible.");
            }
            if (Collections.indexOfSubList(otherFactory.atomicPropositions(), factory.atomicPropositions()) == 0) {
                factory = otherFactory;
                continue;
            }
            if (Collections.indexOfSubList(factory.atomicPropositions(), otherFactory.atomicPropositions()) == 0) continue;
            throw new IllegalArgumentException("Could not find shared alphabet.");
        }
        return Pair.of(factory, symbolicOperationsAllowed);
    }

    private static <A extends OmegaAcceptance> EmersonLeiAcceptance intersectionAcceptance(List<A> acceptanceConditions) {
        ArrayList intersectionConjuncts = new ArrayList();
        int intersectionAcceptanceSets = 0;
        for (OmegaAcceptance acceptance : acceptanceConditions) {
            BooleanExpression<AtomAcceptance> shifted = BooleanExpressions.shift(acceptance.booleanExpression(), intersectionAcceptanceSets);
            intersectionConjuncts.addAll(BooleanExpressions.getConjuncts(shifted));
            intersectionAcceptanceSets += acceptance.acceptanceSets();
        }
        BooleanExpression intersectionExpression = BooleanExpressions.createConjunction(intersectionConjuncts);
        return new EmersonLeiAcceptance(intersectionAcceptanceSets, intersectionExpression);
    }

    private static <A extends OmegaAcceptance> EmersonLeiAcceptance unionAcceptance(List<A> acceptanceConditions) {
        ArrayList unionDisjuncts = new ArrayList();
        int unionAcceptanceSets = 0;
        for (OmegaAcceptance acceptance : acceptanceConditions) {
            BooleanExpression<AtomAcceptance> shifted = BooleanExpressions.shift(acceptance.booleanExpression(), unionAcceptanceSets);
            unionDisjuncts.addAll(BooleanExpressions.getDisjuncts(shifted));
            unionAcceptanceSets += acceptance.acceptanceSets();
        }
        BooleanExpression unionExpression = BooleanExpressions.createDisjunction(unionDisjuncts);
        return new EmersonLeiAcceptance(unionAcceptanceSets, unionExpression);
    }

    private static class ReplacedAcceptanceConditionView<S, A extends OmegaAcceptance>
    implements Automaton<S, A> {
        private final A acceptance;
        private final Automaton<S, ?> backingAutomaton;

        private ReplacedAcceptanceConditionView(Automaton<S, ?> backingAutomaton, A acceptance) {
            this.acceptance = acceptance;
            this.backingAutomaton = backingAutomaton;
        }

        @Override
        public Set<Edge<S>> edges(S state, BitSet valuation) {
            return this.backingAutomaton.edges(state, valuation);
        }

        @Override
        public Map<Edge<S>, ValuationSet> edgeMap(S state) {
            return this.backingAutomaton.edgeMap(state);
        }

        @Override
        public ValuationTree<Edge<S>> edgeTree(S state) {
            return this.backingAutomaton.edgeTree(state);
        }

        @Override
        public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
            return this.backingAutomaton.preferredEdgeAccess();
        }

        @Override
        public A acceptance() {
            return this.acceptance;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.backingAutomaton.factory();
        }

        @Override
        public Set<S> initialStates() {
            return this.backingAutomaton.initialStates();
        }

        @Override
        public Set<S> states() {
            return this.backingAutomaton.states();
        }

        @Override
        public void accept(Automaton.EdgeVisitor<S> visitor) {
            this.backingAutomaton.accept(visitor);
        }

        @Override
        public void accept(Automaton.EdgeMapVisitor<S> visitor) {
            this.backingAutomaton.accept(visitor);
        }

        @Override
        public void accept(Automaton.EdgeTreeVisitor<S> visitor) {
            this.backingAutomaton.accept(visitor);
        }

        @Override
        public void accept(Automaton.Visitor<S> visitor) {
            this.backingAutomaton.accept(visitor);
        }

        @Override
        public boolean is(Automaton.Property property) {
            return this.backingAutomaton.is(property);
        }
    }

    private static class MapDeterministicUnionAutomaton<S>
    extends AbstractImmutableAutomaton.SemiDeterministicEdgesAutomaton<Map<Integer, S>, EmersonLeiAcceptance> {
        private final List<Automaton<S, ?>> automata;

        private MapDeterministicUnionAutomaton(List<Automaton<S, ?>> automata, Pair<ValuationSetFactory, Boolean> factory) {
            super(factory.fst(), Set.of(MapDeterministicUnionAutomaton.initialState(automata)), BooleanOperations.unionAcceptance(automata.stream().map(Automaton::acceptance).collect(Collectors.toList())));
            this.automata = List.copyOf(automata);
        }

        private static <S> Map<Integer, S> initialState(List<Automaton<S, ?>> automata) {
            HashMap<Integer, S> initialStates = new HashMap<Integer, S>();
            int s = automata.size();
            for (int i = 0; i < s; ++i) {
                Set<S> localInitialStates = automata.get(i).initialStates();
                if (localInitialStates.isEmpty()) continue;
                if (localInitialStates.size() >= 2) {
                    throw new IllegalArgumentException("Given automaton is not deterministic.");
                }
                initialStates.put(i, localInitialStates.iterator().next());
            }
            return Map.copyOf(initialStates);
        }

        @Override
        public Edge<Map<Integer, S>> edge(Map<Integer, S> state, BitSet valuation) {
            HashMap<Integer, Edge<S>> edges = new HashMap<Integer, Edge<S>>();
            state.forEach((index, localState) -> edges.put((Integer)index, this.automata.get((int)index).edge(localState, valuation)));
            return this.combine(edges);
        }

        @Nullable
        private Edge<Map<Integer, S>> combine(Map<Integer, Edge<S>> edges) {
            HashMap<Integer, S> successor = new HashMap<Integer, S>();
            BitSet acceptance = new BitSet();
            int offset = 0;
            int s = this.automata.size();
            for (int i = 0; i < s; ++i) {
                Edge<S> edge = edges.get(i);
                if (edge != null) {
                    successor.put(i, edge.successor());
                    int offsetFinal = offset;
                    edge.forEachAcceptanceSet(set -> acceptance.set(set + offsetFinal));
                }
                offset += ((OmegaAcceptance)this.automata.get(i).acceptance()).acceptanceSets();
            }
            if (successor.isEmpty()) {
                return null;
            }
            return Edge.of(Map.copyOf(successor), acceptance);
        }
    }

    private static class NullablePairDeterministicUnionAutomaton<S1, S2>
    extends AbstractImmutableAutomaton.SemiDeterministicEdgesAutomaton<NullablePair<S1, S2>, EmersonLeiAcceptance> {
        private final Automaton<S1, ?> automaton1;
        private final Automaton<S2, ?> automaton2;

        private NullablePairDeterministicUnionAutomaton(Automaton<S1, ?> automaton1, Automaton<S2, ?> automaton2, Pair<ValuationSetFactory, Boolean> factory) {
            super(factory.fst(), Set.of(NullablePairDeterministicUnionAutomaton.initialState(automaton1, automaton2)), BooleanOperations.unionAcceptance(List.of(automaton1.acceptance(), automaton2.acceptance())));
            this.automaton1 = automaton1;
            this.automaton2 = automaton2;
        }

        private static <S1, S2> NullablePair<S1, S2> initialState(Automaton<S1, ?> automata1, Automaton<S2, ?> automata2) {
            Object initialState1 = Iterables.getOnlyElement(automata1.initialStates(), null);
            Object initialState2 = Iterables.getOnlyElement(automata2.initialStates(), null);
            return NullablePair.of(initialState1, initialState2);
        }

        @Override
        public Edge<NullablePair<S1, S2>> edge(NullablePair<S1, S2> state, BitSet valuation) {
            Edge<S1> edge1 = state.fst() == null ? null : this.automaton1.edge(state.fst(), valuation);
            Edge<S2> edge2 = state.snd() == null ? null : this.automaton2.edge(state.snd(), valuation);
            return this.combine(edge1, edge2);
        }

        @Nullable
        private Edge<NullablePair<S1, S2>> combine(@Nullable Edge<S1> edge1, @Nullable Edge<S2> edge2) {
            Object successor1 = null;
            Object successor2 = null;
            BitSet acceptance = new BitSet();
            if (edge1 == null && edge2 == null) {
                return null;
            }
            if (edge1 != null) {
                successor1 = edge1.successor();
                edge1.forEachAcceptanceSet(acceptance::set);
            }
            if (edge2 != null) {
                successor2 = edge2.successor();
                int offset = ((OmegaAcceptance)this.automaton1.acceptance()).acceptanceSets();
                edge2.forEachAcceptanceSet(i -> acceptance.set(i + offset));
            }
            return Edge.of(NullablePair.of(successor1, successor2), acceptance);
        }
    }

    private static class ListIntersectionAutomaton<S>
    extends AbstractImmutableAutomaton<List<S>, EmersonLeiAcceptance> {
        private final List<Automaton<S, ?>> automata;
        private final boolean symbolicOperationsAllowed;

        private ListIntersectionAutomaton(List<Automaton<S, ?>> automata, Pair<ValuationSetFactory, Boolean> factory) {
            super(factory.fst(), ListIntersectionAutomaton.initialStates(automata), BooleanOperations.intersectionAcceptance(automata.stream().map(Automaton::acceptance).collect(Collectors.toList())));
            this.automata = List.copyOf(automata);
            this.symbolicOperationsAllowed = factory.snd();
        }

        private static <S> Set<List<S>> initialStates(List<Automaton<S, ?>> automata) {
            return Sets.cartesianProduct(automata.stream().map(Automaton::initialStates).collect(Collectors.toList()));
        }

        @Override
        public Set<Edge<List<S>>> edges(List<S> state, BitSet valuation) {
            ArrayList<Set<Edge<S>>> edges = new ArrayList<Set<Edge<S>>>();
            int s = this.automata.size();
            for (int i = 0; i < s; ++i) {
                edges.add(this.automata.get(i).edges(state.get(i), valuation));
            }
            return Sets.cartesianProduct(edges).stream().map(this::combine).collect(Collectors.toSet());
        }

        @Override
        public Map<Edge<List<S>>, ValuationSet> edgeMap(List<S> state) {
            if (!this.symbolicOperationsAllowed) {
                return this.edgeTree(state).inverse(this.factory());
            }
            ArrayList<Set<Map.Entry<Edge<S>, ValuationSet>>> edgeMaps = new ArrayList<Set<Map.Entry<Edge<S>, ValuationSet>>>();
            int s = this.automata.size();
            for (int i = 0; i < s; ++i) {
                edgeMaps.add(this.automata.get(i).edgeMap(state.get(i)).entrySet());
            }
            HashMap<Edge<List<S>>, ValuationSet> edgeMap = new HashMap<Edge<List<S>>, ValuationSet>();
            for (List edgeList : Sets.cartesianProduct(edgeMaps)) {
                ValuationSet intersection = edgeList.stream().map(Map.Entry::getValue).reduce(ValuationSet::intersection).orElseThrow();
                if (intersection.isEmpty()) continue;
                List<Edge<S>> list = edgeList.stream().map(Map.Entry::getKey).collect(Collectors.toList());
                edgeMap.merge(this.combine(list), intersection, ValuationSet::union);
            }
            return edgeMap;
        }

        @Override
        public ValuationTree<Edge<List<S>>> edgeTree(List<S> state) {
            ArrayList<ValuationTree<ValuationTree<Edge<S>>>> edgeTrees = new ArrayList<ValuationTree<ValuationTree<Edge<S>>>>();
            int s = this.automata.size();
            for (int i = 0; i < s; ++i) {
                edgeTrees.add(this.automata.get(i).edgeTree(state.get(i)));
            }
            return ValuationTrees.cartesianProduct(edgeTrees).map(x -> x.stream().map(this::combine).collect(Collectors.toUnmodifiableSet()));
        }

        @Override
        public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
            return this.automata.get(0).preferredEdgeAccess();
        }

        private Edge<List<S>> combine(List<Edge<S>> edges) {
            ArrayList<S> successors = new ArrayList<S>();
            BitSet acceptance = new BitSet();
            int offset = 0;
            int s = this.automata.size();
            for (int i = 0; i < s; ++i) {
                int offsetFinal = offset;
                Edge<S> edge = edges.get(i);
                successors.add(edge.successor());
                edge.forEachAcceptanceSet(set -> acceptance.set(set + offsetFinal));
                offset += ((OmegaAcceptance)this.automata.get(i).acceptance()).acceptanceSets();
            }
            return Edge.of(List.copyOf(successors), acceptance);
        }
    }

    private static class PairIntersectionAutomaton<S1, S2>
    extends AbstractImmutableAutomaton<Pair<S1, S2>, EmersonLeiAcceptance> {
        private final Automaton<S1, ?> automaton1;
        private final Automaton<S2, ?> automaton2;
        private final boolean symbolicOperationsAllowed;
        private final int acceptance1Sets;

        private PairIntersectionAutomaton(Automaton<S1, ?> automaton1, Automaton<S2, ?> automaton2, Pair<ValuationSetFactory, Boolean> factory) {
            super(factory.fst(), Pair.allPairs(automaton1.initialStates(), automaton2.initialStates()), BooleanOperations.intersectionAcceptance(List.of(automaton1.acceptance(), automaton2.acceptance())));
            this.automaton1 = automaton1;
            this.automaton2 = automaton2;
            this.acceptance1Sets = ((OmegaAcceptance)automaton1.acceptance()).acceptanceSets();
            this.symbolicOperationsAllowed = factory.snd();
        }

        @Override
        public Set<Edge<Pair<S1, S2>>> edges(Pair<S1, S2> state, BitSet valuation) {
            Set<Edge<S1>> edges1 = this.automaton1.edges(state.fst(), valuation);
            Set<Edge<S2>> edges2 = this.automaton2.edges(state.snd(), valuation);
            HashSet<Edge<Pair<S1, S2>>> edges = new HashSet<Edge<Pair<S1, S2>>>();
            for (Edge<S1> edge1 : edges1) {
                for (Edge<S2> edge2 : edges2) {
                    edges.add(this.combine(edge1, edge2));
                }
            }
            return edges;
        }

        @Override
        public Map<Edge<Pair<S1, S2>>, ValuationSet> edgeMap(Pair<S1, S2> state) {
            if (!this.symbolicOperationsAllowed) {
                return this.edgeTree(state).inverse(this.factory());
            }
            Map<Edge<S1>, ValuationSet> edgeMap1 = this.automaton1.edgeMap(state.fst());
            Map<Edge<S2>, ValuationSet> edgeMap2 = this.automaton2.edgeMap(state.snd());
            HashMap<Edge<Pair<S1, S2>>, ValuationSet> edgeMap = new HashMap<Edge<Pair<S1, S2>>, ValuationSet>();
            edgeMap1.forEach((edge1, valuationSet1) -> edgeMap2.forEach((edge2, valuationSet2) -> {
                ValuationSet intersection = valuationSet1.intersection((ValuationSet)valuationSet2);
                if (!intersection.isEmpty()) {
                    edgeMap.merge(this.combine((Edge<S1>)edge1, (Edge<S2>)edge2), intersection, ValuationSet::union);
                }
            }));
            return edgeMap;
        }

        @Override
        public ValuationTree<Edge<Pair<S1, S2>>> edgeTree(Pair<S1, S2> state) {
            ValuationTree<Edge<S1>> edgeTree1 = this.automaton1.edgeTree(state.fst());
            ValuationTree<Edge<S2>> edgeTree2 = this.automaton2.edgeTree(state.snd());
            return ValuationTrees.cartesianProduct(edgeTree1, edgeTree2, this::combine);
        }

        @Override
        public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
            return this.automaton1.preferredEdgeAccess();
        }

        private Edge<Pair<S1, S2>> combine(Edge<S1> edge1, Edge<S2> edge2) {
            BitSet acceptance = edge1.acceptanceSets();
            edge2.forEachAcceptanceSet(set -> acceptance.set(set + this.acceptance1Sets));
            return Edge.of(Pair.of(edge1.successor(), edge2.successor()), acceptance);
        }
    }
}

