/*
 * Decompiled with CFR 0.152.
 */
package owl.util;

import com.google.common.math.Stats;
import java.math.BigInteger;
import java.util.Arrays;

public final class Statistics {
    private Statistics() {
    }

    public static double arithmeticMean(int ... values) {
        return Arrays.stream(values).summaryStatistics().getAverage();
    }

    public static double geometricMean(int ... values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        BigInteger product = BigInteger.ONE;
        for (int value : values) {
            product = product.multiply(BigInteger.valueOf(value));
        }
        return Math.pow(Math.E, Math.log(product.doubleValue()) / (double)values.length);
    }

    public static double median(int ... values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        int[] valuesCopy = (int[])values.clone();
        Arrays.sort(valuesCopy);
        int middle = valuesCopy.length / 2;
        if (valuesCopy.length % 2 == 1) {
            return valuesCopy[middle];
        }
        return (double)(valuesCopy[middle - 1] + valuesCopy[middle]) / 2.0;
    }

    public static double standardDeviation(int ... values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        return Stats.of((int[])values).populationStandardDeviation();
    }
}

