/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.Visitor;

class SyntacticFairnessSimplifier
implements UnaryOperator<Formula> {
    static final UnaryOperator<Formula> INSTANCE = new TraverseRewriter(new SyntacticFairnessSimplifier(), SyntacticFairnessSimplifier::isApplicable);
    static final AlmostAllVisitor ALMOST_ALL_VISITOR = new AlmostAllVisitor();
    static final InfinitelyOftenVisitor INFINITELY_OFTEN_VISITOR = new InfinitelyOftenVisitor();

    SyntacticFairnessSimplifier() {
    }

    @Nullable
    static Formula getAlmostAllOperand(Formula formula) {
        FOperator fOperator;
        if (formula instanceof FOperator && (fOperator = (FOperator)formula).operand() instanceof GOperator) {
            return ((GOperator)fOperator.operand()).operand();
        }
        return null;
    }

    @Nullable
    static Formula getInfinitelyOftenOperand(Formula formula) {
        GOperator gOperator;
        if (formula instanceof GOperator && (gOperator = (GOperator)formula).operand() instanceof FOperator) {
            return ((FOperator)gOperator.operand()).operand();
        }
        return null;
    }

    public static boolean isApplicable(Formula formula) {
        return SyntacticFragment.FGX.contains(formula) && (SyntacticFairnessSimplifier.getAlmostAllOperand(formula) != null || SyntacticFairnessSimplifier.getInfinitelyOftenOperand(formula) != null);
    }

    public static boolean isApplicable2(Formula formula) {
        if (!SyntacticFragment.FGX.contains(formula)) {
            return false;
        }
        if (formula instanceof FOperator) {
            Formula operand = ((FOperator)formula).operand();
            while (operand instanceof XOperator) {
                operand = ((XOperator)operand).operand();
            }
            return operand instanceof GOperator;
        }
        if (formula instanceof GOperator) {
            Formula operand = ((GOperator)formula).operand();
            while (operand instanceof XOperator) {
                operand = ((XOperator)operand).operand();
            }
            return operand instanceof FOperator;
        }
        return false;
    }

    @Override
    public Formula apply(Formula formula) {
        assert (SyntacticFairnessSimplifier.isApplicable(formula));
        Formula almostAll = SyntacticFairnessSimplifier.getAlmostAllOperand(formula);
        if (almostAll != null) {
            return almostAll.accept(ALMOST_ALL_VISITOR);
        }
        Formula infinitelyOften = SyntacticFairnessSimplifier.getInfinitelyOftenOperand(formula);
        if (infinitelyOften != null) {
            return infinitelyOften.accept(INFINITELY_OFTEN_VISITOR);
        }
        throw new AssertionError((Object)"Unreachable");
    }

    private static Formula shortCircuit(Formula formula) {
        if (formula instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)formula;
            if (conjunction.operands.stream().anyMatch(x -> conjunction.operands.contains(x.not()))) {
                return BooleanConstant.FALSE;
            }
        }
        if (formula instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)formula;
            if (disjunction.operands.stream().anyMatch(x -> disjunction.operands.contains(x.not()))) {
                return BooleanConstant.TRUE;
            }
        }
        return formula;
    }

    static class TraverseRewriter
    implements UnaryOperator<Formula>,
    Visitor<Formula> {
        private final Predicate<Formula> isApplicable;
        private final UnaryOperator<Formula> rewriter;

        TraverseRewriter(UnaryOperator<Formula> rewriter, Predicate<Formula> applicable) {
            this.rewriter = rewriter;
            this.isApplicable = applicable;
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            if (this.isApplicable.test(booleanConstant)) {
                return (Formula)this.rewriter.apply(booleanConstant);
            }
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            if (this.isApplicable.test(conjunction)) {
                return (Formula)this.rewriter.apply(conjunction);
            }
            return Conjunction.of(conjunction.operands.stream().map(this));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            if (this.isApplicable.test(disjunction)) {
                return (Formula)this.rewriter.apply(disjunction);
            }
            return Disjunction.of(disjunction.operands.stream().map(this));
        }

        @Override
        public Formula visit(FOperator fOperator) {
            if (this.isApplicable.test(fOperator)) {
                return (Formula)this.rewriter.apply(fOperator);
            }
            return FOperator.of(fOperator.operand().accept(this));
        }

        @Override
        public Formula visit(GOperator gOperator) {
            if (this.isApplicable.test(gOperator)) {
                return (Formula)this.rewriter.apply(gOperator);
            }
            return GOperator.of(gOperator.operand().accept(this));
        }

        @Override
        public Formula visit(Literal literal) {
            if (this.isApplicable.test(literal)) {
                return (Formula)this.rewriter.apply(literal);
            }
            return literal;
        }

        @Override
        public Formula visit(MOperator mOperator) {
            if (this.isApplicable.test(mOperator)) {
                return (Formula)this.rewriter.apply(mOperator);
            }
            return MOperator.of(mOperator.leftOperand().accept(this), mOperator.rightOperand().accept(this));
        }

        @Override
        public Formula visit(ROperator rOperator) {
            if (this.isApplicable.test(rOperator)) {
                return (Formula)this.rewriter.apply(rOperator);
            }
            return ROperator.of(rOperator.leftOperand().accept(this), rOperator.rightOperand().accept(this));
        }

        @Override
        public Formula visit(UOperator uOperator) {
            if (this.isApplicable.test(uOperator)) {
                return (Formula)this.rewriter.apply(uOperator);
            }
            return UOperator.of(uOperator.leftOperand().accept(this), uOperator.rightOperand().accept(this));
        }

        @Override
        public Formula visit(WOperator wOperator) {
            if (this.isApplicable.test(wOperator)) {
                return (Formula)this.rewriter.apply(wOperator);
            }
            return WOperator.of(wOperator.leftOperand().accept(this), wOperator.rightOperand().accept(this));
        }

        @Override
        public Formula visit(XOperator xOperator) {
            if (this.isApplicable.test(xOperator)) {
                return (Formula)this.rewriter.apply(xOperator);
            }
            return XOperator.of(xOperator.operand().accept(this));
        }
    }

    static final class NormaliseX
    implements BinaryVisitor<Integer, Formula> {
        static final NormaliseX UNGUARDED_INSTANCE = new NormaliseX();
        static final UnaryOperator<Formula> UNGUARDED_OPERATOR = f -> f.accept(UNGUARDED_INSTANCE, 0);
        static final UnaryOperator<Formula> INSTANCE = new TraverseRewriter(UNGUARDED_OPERATOR, SyntacticFairnessSimplifier::isApplicable);

        NormaliseX() {
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant, Integer depth) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction, Integer depth) {
            if (SyntacticFragments.isFinite(conjunction)) {
                return XOperator.of(conjunction, depth);
            }
            return Conjunction.of(conjunction.map(x -> x.accept(this, depth)));
        }

        @Override
        public Formula visit(Disjunction disjunction, Integer depth) {
            if (SyntacticFragments.isFinite(disjunction)) {
                return XOperator.of(disjunction, depth);
            }
            return Disjunction.of(disjunction.map(x -> x.accept(this, depth)));
        }

        @Override
        public Formula visit(FOperator fOperator, Integer depth) {
            return new FOperator(fOperator.operand().accept(this, 0));
        }

        @Override
        public Formula visit(GOperator gOperator, Integer depth) {
            return new GOperator(gOperator.operand().accept(this, 0));
        }

        @Override
        public Formula visit(Literal literal, Integer parameter) {
            return XOperator.of(literal, parameter);
        }

        @Override
        public Formula visit(XOperator xOperator, Integer parameter) {
            return xOperator.operand().accept(this, parameter + 1);
        }
    }

    private static final class InfinitelyOftenVisitor
    implements Visitor<Formula> {
        private InfinitelyOftenVisitor() {
        }

        private static Formula wrap(Formula formula) {
            if (formula instanceof BooleanConstant) {
                return formula;
            }
            return new GOperator(new FOperator(formula));
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            if (SyntacticFragments.isFinite(conjunction)) {
                return InfinitelyOftenVisitor.wrap(SyntacticFairnessSimplifier.shortCircuit(conjunction));
            }
            ArrayList<Formula> conjuncts = new ArrayList<Formula>();
            ArrayList xFragment = new ArrayList();
            ArrayList<List<Formula>> disjuncts = new ArrayList<List<Formula>>();
            conjunction.operands.forEach(child -> {
                if (child instanceof FOperator) {
                    conjuncts.add(((FOperator)child).operand().accept(this));
                } else if (child instanceof GOperator) {
                    conjuncts.add(((GOperator)child).operand().accept(ALMOST_ALL_VISITOR));
                } else if (SyntacticFragments.isFinite(child)) {
                    xFragment.add(child);
                } else {
                    assert (child instanceof Disjunction);
                    disjuncts.add(child.operands);
                }
            });
            disjuncts.add(List.of(Conjunction.of(xFragment)));
            Formula disjunction = Disjunction.of(Lists.cartesianProduct(disjuncts).stream().map(Conjunction::of));
            conjuncts.add(disjunction.accept(this));
            return SyntacticFairnessSimplifier.shortCircuit(Conjunction.of(conjuncts));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            if (SyntacticFragments.isFinite(disjunction)) {
                return InfinitelyOftenVisitor.wrap(SyntacticFairnessSimplifier.shortCircuit(disjunction));
            }
            return SyntacticFairnessSimplifier.shortCircuit(Disjunction.of(disjunction.map(x -> x.accept(this))));
        }

        @Override
        public Formula visit(FOperator fOperator) {
            return fOperator.operand().accept(this);
        }

        @Override
        public Formula visit(GOperator gOperator) {
            return gOperator.operand().accept(ALMOST_ALL_VISITOR);
        }

        @Override
        public Formula visit(Literal literal) {
            return InfinitelyOftenVisitor.wrap(literal);
        }

        @Override
        public Formula visit(XOperator xOperator) {
            return xOperator.operand().accept(this);
        }
    }

    private static final class AlmostAllVisitor
    implements Visitor<Formula> {
        private AlmostAllVisitor() {
        }

        private static Formula wrap(Formula formula) {
            if (formula instanceof BooleanConstant) {
                return formula;
            }
            return new FOperator(new GOperator(formula));
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            if (SyntacticFragments.isFinite(conjunction)) {
                return AlmostAllVisitor.wrap(SyntacticFairnessSimplifier.shortCircuit(conjunction));
            }
            return SyntacticFairnessSimplifier.shortCircuit(Conjunction.of(conjunction.map(x -> x.accept(this))));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            if (SyntacticFragments.isFinite(disjunction)) {
                return AlmostAllVisitor.wrap(SyntacticFairnessSimplifier.shortCircuit(disjunction));
            }
            ArrayList<Formula> disjuncts = new ArrayList<Formula>();
            ArrayList xFragment = new ArrayList();
            ArrayList<List<Formula>> conjuncts = new ArrayList<List<Formula>>();
            disjunction.operands.forEach(child -> {
                if (child instanceof FOperator) {
                    disjuncts.add(((FOperator)child).operand().accept(INFINITELY_OFTEN_VISITOR));
                } else if (child instanceof GOperator) {
                    disjuncts.add(((GOperator)child).operand().accept(this));
                } else if (SyntacticFragments.isFinite(child)) {
                    xFragment.add(child);
                } else {
                    assert (child instanceof Conjunction);
                    conjuncts.add(child.operands);
                }
            });
            conjuncts.add(List.of(Disjunction.of(xFragment)));
            Formula conjunction = Conjunction.of(Lists.cartesianProduct(conjuncts).stream().map(Disjunction::of));
            disjuncts.add(conjunction.accept(this));
            return SyntacticFairnessSimplifier.shortCircuit(Disjunction.of(disjuncts));
        }

        @Override
        public Formula visit(FOperator fOperator) {
            return fOperator.operand().accept(INFINITELY_OFTEN_VISITOR);
        }

        @Override
        public Formula visit(GOperator gOperator) {
            return gOperator.operand().accept(this);
        }

        @Override
        public Formula visit(Literal literal) {
            return AlmostAllVisitor.wrap(literal);
        }

        @Override
        public Formula visit(XOperator xOperator) {
            return xOperator.operand().accept(this);
        }
    }
}

