/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.output;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerPrint;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.output.HoaConsumerExtended;

public final class HoaPrinter {
    private HoaPrinter() {
    }

    public static <S> String toString(Automaton<S, ?> automaton) {
        return HoaPrinter.toString(automaton, EnumSet.of(HoaOption.ANNOTATIONS));
    }

    public static <S> String toString(Automaton<S, ?> automaton, EnumSet<HoaOption> options) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        HoaPrinter.feedTo(automaton, (HOAConsumer)new HOAConsumerPrint((OutputStream)writer), options);
        return new String(writer.toByteArray(), StandardCharsets.UTF_8);
    }

    public static <S> void feedTo(Automaton<S, ?> automaton, HOAConsumer consumer) {
        HoaPrinter.feedTo(automaton, consumer, EnumSet.noneOf(HoaOption.class));
    }

    public static <S> void feedTo(Automaton<S, ?> automaton, HOAConsumer consumer, EnumSet<HoaOption> options) {
        HoaConsumerExtended<S> hoa = new HoaConsumerExtended<S>(consumer, automaton.factory().alphabet(), (OmegaAcceptance)automaton.acceptance(), automaton.initialStates(), options, automaton.is(Automaton.Property.DETERMINISTIC), automaton.name());
        automaton.accept((Automaton.Visitor<S>)hoa.visitor);
        hoa.done();
    }

    public static enum HoaOption {
        ANNOTATIONS;

    }
}

