/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.Formulas;

public abstract class PropositionalFormula
extends Formula.LogicalOperator {
    public final Set<Formula> children;

    PropositionalFormula(Class<? extends PropositionalFormula> clazz, Set<Formula> children) {
        super(Objects.hash(clazz, children));
        this.children = Set.copyOf(children);
    }

    public static Formula shortCircuit(Formula formula) {
        if (formula instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)formula;
            if (conjunction.children.stream().anyMatch((? super T x) -> conjunction.children.contains(x.not()))) {
                return BooleanConstant.FALSE;
            }
        }
        if (formula instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)formula;
            if (disjunction.children.stream().anyMatch((? super T x) -> disjunction.children.contains(x.not()))) {
                return BooleanConstant.TRUE;
            }
        }
        return formula;
    }

    @Override
    public Set<Formula> children() {
        return this.children;
    }

    @Override
    public boolean isPureEventual() {
        return this.children.stream().allMatch(Formula::isPureEventual);
    }

    @Override
    public boolean isPureUniversal() {
        return this.children.stream().allMatch(Formula::isPureUniversal);
    }

    public <T> Stream<T> map(Function<? super Formula, ? extends T> mapper) {
        return this.children.stream().map(mapper);
    }

    public String toString() {
        return this.children.stream().map(Object::toString).collect(Collectors.joining(this.operatorSymbol(), "(", ")"));
    }

    @Override
    protected final int compareToImpl(Formula o) {
        assert (this.getClass().equals(o.getClass()));
        PropositionalFormula that = (PropositionalFormula)o;
        return Formulas.compare(this.children, that.children);
    }

    @Override
    protected final boolean equalsImpl(Formula o) {
        assert (this.getClass().equals(o.getClass()));
        PropositionalFormula that = (PropositionalFormula)o;
        return this.children.equals(that.children);
    }

    protected abstract String operatorSymbol();
}

