/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.BddImpl;
import de.tum.in.jbdd.SynchronizedBdd;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class BddFactory {
    private BddFactory() {
    }

    public static Bdd buildBdd(int nodeSize) {
        return new BddImpl(nodeSize);
    }

    public static Bdd buildBdd(int nodeSize, BddConfiguration configuration) {
        return new BddImpl(nodeSize, configuration);
    }

    public static SynchronizedBdd buildSynchronizedBdd(int nodeSize) {
        return BddFactory.synchronize(new BddImpl(nodeSize));
    }

    public static SynchronizedBdd buildSynchronizedBdd(int nodeSize, BddConfiguration configuration) {
        return BddFactory.synchronize(new BddImpl(nodeSize, configuration));
    }

    private static SynchronizedBdd synchronize(BddImpl bdd) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        return new SynchronizedBdd(bdd, lock);
    }
}

