/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2ldba;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.ldba.MutableAutomatonBuilder;
import owl.translations.nba2ldba.BreakpointState;

final class AcceptingComponentBuilder<S>
implements MutableAutomatonBuilder<S, BreakpointState<S>, BuchiAcceptance> {
    private final List<BreakpointState<S>> initialStates;
    private final int max;
    private final Automaton<S, GeneralizedBuchiAcceptance> nba;
    private final List<Set<S>> sccs;
    @Nullable
    private final Edge<BreakpointState<S>> sinkEdge;

    AcceptingComponentBuilder(Automaton<S, GeneralizedBuchiAcceptance> nba, boolean complete) {
        this.nba = nba;
        this.initialStates = new ArrayList<BreakpointState<S>>();
        this.max = Math.max(nba.acceptance().acceptanceSets(), 1);
        this.sccs = SccDecomposition.computeSccs(nba, false);
        this.sinkEdge = complete ? Edge.of(BreakpointState.sink()) : null;
    }

    @Override
    public BreakpointState<S> add(S stateKey) {
        BreakpointState<S> state = BreakpointState.of(0, Set.of(stateKey), Set.of());
        this.initialStates.add(state);
        return state;
    }

    @Override
    public MutableAutomaton<BreakpointState<S>, BuchiAcceptance> build() {
        return MutableAutomatonFactory.create(BuchiAcceptance.INSTANCE, this.nba.factory(), this.initialStates, this::explore, x -> null);
    }

    @Nullable
    private Edge<BreakpointState<S>> explore(BreakpointState<S> ldbaState, BitSet valuation) {
        Set n1;
        int i1;
        Optional<Set> optionalScc = this.sccs.stream().filter(x -> x.containsAll(ldbaState.mx())).findAny();
        if (!optionalScc.isPresent()) {
            return this.sinkEdge;
        }
        Set scc = optionalScc.get();
        Set outEdgesM = ldbaState.mx().stream().flatMap(x -> this.nba.edges(x, valuation).stream()).filter(x -> scc.contains(x.successor())).collect(Collectors.toSet());
        if (outEdgesM.isEmpty()) {
            return this.sinkEdge;
        }
        Set outEdgesN = ldbaState.nx().stream().flatMap(x -> this.nba.edges(x, valuation).stream()).filter(x -> scc.contains(x.successor())).collect(Collectors.toSet());
        Set intersection = outEdgesM.stream().filter(x -> x.inSet(ldbaState.ix() % this.max)).collect(Collectors.toSet());
        outEdgesN.addAll(intersection);
        if (outEdgesM.equals(outEdgesN)) {
            i1 = (ldbaState.ix() + 1) % this.max;
            n1 = outEdgesM.stream().filter(x -> x.inSet(i1)).map(Edge::successor).collect(Collectors.toSet());
        } else {
            n1 = outEdgesN.stream().map(Edge::successor).collect(Collectors.toSet());
            i1 = ldbaState.ix();
        }
        BreakpointState successor = BreakpointState.of(i1, outEdgesM.stream().map(Edge::successor).collect(Collectors.toSet()), n1);
        return i1 == 0 && outEdgesM.equals(outEdgesN) ? Edge.of(successor, 0) : Edge.of(successor);
    }
}

