/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2dpa;

import java.util.EnumSet;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonUtil;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.automaton.ldba.LimitDeterministicAutomatonBuilder;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModuleParser;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ldba2dpa.FlatRankingAutomaton;
import owl.translations.nba2dpa.SetLanguageLattice;
import owl.translations.nba2ldba.NBA2LDBA;

public final class NBA2DPA
implements Function<Automaton<?, ?>, Automaton<?, ParityAcceptance>> {
    private final NBA2LDBA nba2ldba = new NBA2LDBA(true, EnumSet.of(LimitDeterministicAutomatonBuilder.Configuration.SUPPRESS_JUMPS_FOR_TRANSIENT_STATES));
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("nba2dpa").description("Converts a non-deterministic B\u00fcchi automaton into a deterministic parity automaton").parser(settings -> environment -> {
        NBA2DPA nba2dpa = new NBA2DPA();
        return (input, context) -> nba2dpa.apply(AutomatonUtil.cast(input));
    }).build();

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder("nba2dpa").reader(InputReaders.HOA).addTransformer(CLI).writer(OutputWriters.HOA).build());
    }

    @Override
    public Automaton<?, ParityAcceptance> apply(Automaton<?, ?> automaton) {
        LimitDeterministicAutomaton<?, ?, BuchiAcceptance, Void> ldba = this.nba2ldba.apply(automaton);
        if (ldba.initialStates().isEmpty()) {
            return AutomatonFactory.singleton(automaton.factory(), new Object(), new ParityAcceptance(1, ParityAcceptance.Parity.MIN_ODD));
        }
        assert (ldba.initialStates().size() == 1);
        SetLanguageLattice oracle = new SetLanguageLattice(ldba.acceptingComponent());
        return FlatRankingAutomaton.of(ldba, oracle, x -> false, false, true);
    }
}

