/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba.breakpointfree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.collections.Collections3;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.UnaryModalOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.SimplifierFactory;
import owl.ltl.visitors.Collector;
import owl.ltl.visitors.Visitor;
import owl.translations.ltl2ldba.AbstractJumpManager;
import owl.translations.ltl2ldba.Jump;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.breakpointfree.FGObligations;

public final class FGObligationsJumpManager
extends AbstractJumpManager<FGObligations> {
    private final Table<Set<FOperator>, Set<GOperator>, FGObligations> cache = HashBasedTable.create();

    private FGObligationsJumpManager(EquivalenceClassFactory factories, Set<LTL2LDBAFunction.Configuration> optimisations, Set<Formula> modalOperators, Formula initialFormula) {
        super(optimisations, factories, modalOperators, initialFormula);
    }

    public static FGObligationsJumpManager build(Formula formula, EquivalenceClassFactory factory, Set<LTL2LDBAFunction.Configuration> optimisations) {
        return new FGObligationsJumpManager(factory, optimisations, factory.of(formula).modalOperators(), formula);
    }

    private static Stream<Map.Entry<Set<FOperator>, Set<GOperator>>> createFGSetStream(Formula state) {
        Set<GOperator> gOperators = Collector.collectTransformedGOperators(state);
        Set<FOperator> fOperators = Collector.collectTransformedFOperators(gOperators);
        gOperators.removeIf(x -> x.operand instanceof FOperator);
        fOperators.removeIf(x -> x.operand instanceof GOperator);
        SetMultimap multimap = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Set fSet : Sets.powerSet(fOperators)) {
            for (Set gSet : Sets.powerSet(gOperators)) {
                multimap.put((Object)fSet, (Object)gSet);
            }
        }
        return multimap.entries().stream();
    }

    static Formula replaceFOperators(Set<FOperator> trueFOperators, Set<GOperator> trueGOperators, GOperator formula) {
        ReplaceFOperatorsVisitor visitor = new ReplaceFOperatorsVisitor(trueFOperators, trueGOperators);
        return GOperator.of(formula.operand.accept(visitor));
    }

    private static Formula replaceFOperators(FGObligations obligations, Formula formula) {
        ReplaceFOperatorsVisitor visitor = new ReplaceFOperatorsVisitor(obligations.fOperators, obligations.gOperators);
        return formula.accept(visitor);
    }

    static Formula replaceGOperators(Set<GOperator> trueGOperators, Set<FOperator> trueFOperators, Formula formula) {
        ReplaceGOperatorsVisitor visitor = new ReplaceGOperatorsVisitor(trueGOperators, trueFOperators);
        return formula.accept(visitor);
    }

    static Multimap<Set<FOperator>, Set<GOperator>> selectReducedMonitors(EquivalenceClass state) {
        SetMultimap multimap = MultimapBuilder.hashKeys().hashSetValues().build();
        Formula formula = Objects.requireNonNull(state.representative());
        boolean delayJump = false;
        for (Set<UnaryModalOperator> obligations : formula.accept(TopLevelSelectVisitor.INSTANCE)) {
            Set fOperators = obligations.stream().filter(FOperator.class::isInstance).map(FOperator.class::cast).collect(Collectors.toSet());
            Set gOperators = obligations.stream().filter(GOperator.class::isInstance).map(GOperator.class::cast).collect(Collectors.toSet());
            delayJump |= fOperators.removeIf(x -> x.operand instanceof GOperator);
            gOperators.removeIf(x -> x.operand instanceof FOperator);
            multimap.put(fOperators, gOperators);
        }
        if (delayJump) {
            multimap.put(Set.of(), Set.of());
        }
        return multimap;
    }

    @Override
    protected Set<Jump<FGObligations>> computeJumps(EquivalenceClass state) {
        HashSet<Jump<FGObligations>> fgObligations = new HashSet<Jump<FGObligations>>();
        FGObligationsJumpManager.createDisjunctionStream(state, FGObligationsJumpManager::createFGSetStream).forEach(entry -> {
            Set<GOperator> gOperators;
            Set<FOperator> fOperators = Set.copyOf((Collection)entry.getKey());
            FGObligations obligations = (FGObligations)this.cache.get(fOperators, gOperators = Set.copyOf((Collection)entry.getValue()));
            if (obligations == null && (obligations = FGObligations.build(fOperators, gOperators, this.factory)) != null) {
                this.cache.put(fOperators, gOperators, (Object)obligations);
            }
            if (obligations == null) {
                Logger.getGlobal().log(Level.FINER, () -> "Did not create FGObligations for " + entry);
                return;
            }
            EquivalenceClass remainder = this.evaluate(state, obligations);
            if (!remainder.isFalse()) {
                fgObligations.add(this.buildJump(remainder, obligations));
            }
        });
        return fgObligations;
    }

    private EquivalenceClass evaluate(EquivalenceClass clazz, FGObligations obligation) {
        Formula formula = clazz.representative();
        Formula fFreeFormula = FGObligationsJumpManager.replaceFOperators(obligation, formula);
        Formula evaluated = SimplifierFactory.apply(fFreeFormula, SimplifierFactory.Mode.SYNTACTIC);
        Logger.getGlobal().log(Level.FINER, () -> "Rewrote " + clazz + " into " + evaluated + " using " + obligation);
        return this.factory.of(evaluated);
    }

    @VisibleForTesting
    static class TopLevelSelectVisitor
    extends AbstractSelectVisitor {
        static final TopLevelSelectVisitor INSTANCE = new TopLevelSelectVisitor();

        TopLevelSelectVisitor() {
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(FOperator fOperator) {
            return fOperator.accept(FScopedSelectVisitor.INSTANCE);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(GOperator gOperator) {
            return gOperator.accept(FScopedSelectVisitor.INSTANCE);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(MOperator mOperator) {
            return mOperator.accept(FScopedSelectVisitor.INSTANCE);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(ROperator rOperator) {
            return rOperator.accept(FScopedSelectVisitor.INSTANCE);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(UOperator uOperator) {
            return uOperator.accept(FScopedSelectVisitor.INSTANCE);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(WOperator wOperator) {
            return wOperator.accept(FScopedSelectVisitor.INSTANCE);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(Disjunction disjunction) {
            return TopLevelSelectVisitor.or(Collections2.transform((Collection)disjunction.children, x -> x.accept(this)), false);
        }
    }

    static class ReplaceGOperatorsVisitor
    extends AbstractReplaceOperatorsVisitor {
        private final Set<FOperator> foperators;
        private final Set<GOperator> goperators;

        ReplaceGOperatorsVisitor(Set<GOperator> goperators, Set<FOperator> foperators) {
            this.goperators = Set.copyOf(goperators);
            this.foperators = Set.copyOf(foperators);
        }

        private boolean isTrueGOperator(GOperator gOperator) {
            return gOperator.operand instanceof FOperator && this.foperators.contains(gOperator.operand) || this.goperators.contains(gOperator);
        }

        @Override
        public Formula visit(FOperator fOperator) {
            return FOperator.of(fOperator.operand.accept(this));
        }

        @Override
        public Formula visit(GOperator gOperator) {
            return BooleanConstant.of(this.isTrueGOperator(gOperator));
        }

        @Override
        public Formula visit(Literal literal) {
            if (this.goperators.contains(new GOperator(literal))) {
                return BooleanConstant.TRUE;
            }
            return literal;
        }

        @Override
        public Formula visit(MOperator mOperator) {
            return MOperator.of(mOperator.left.accept(this), mOperator.right.accept(this));
        }

        @Override
        public Formula visit(UOperator uOperator) {
            return UOperator.of(uOperator.left.accept(this), uOperator.right.accept(this));
        }

        @Override
        public Formula visit(ROperator rOperator) {
            if (this.isTrueGOperator(new GOperator(rOperator.right))) {
                return BooleanConstant.TRUE;
            }
            return MOperator.of(rOperator.left.accept(this), rOperator.right.accept(this));
        }

        @Override
        public Formula visit(WOperator wOperator) {
            if (this.isTrueGOperator(new GOperator(wOperator.left))) {
                return BooleanConstant.TRUE;
            }
            return UOperator.of(wOperator.left.accept(this), wOperator.right.accept(this));
        }
    }

    static class ReplaceFOperatorsVisitor
    extends AbstractReplaceOperatorsVisitor {
        private final Set<FOperator> foperators;
        private final Set<GOperator> goperators;

        ReplaceFOperatorsVisitor(Set<FOperator> foperators, Set<GOperator> goperators) {
            this.foperators = Set.copyOf(foperators);
            this.goperators = Set.copyOf(Sets.newHashSet((Iterable)Iterables.concat(goperators, (Iterable)Collections2.transform(foperators, GOperator::new))));
        }

        private boolean isTrueFOperator(FOperator fOperator) {
            return fOperator.operand instanceof GOperator && this.goperators.contains(fOperator.operand) || this.foperators.contains(fOperator);
        }

        @Override
        public Formula visit(FOperator fOperator) {
            return BooleanConstant.of(this.isTrueFOperator(fOperator));
        }

        @Override
        public Formula visit(GOperator gOperator) {
            if (gOperator.operand instanceof FOperator && this.foperators.contains(gOperator.operand)) {
                return BooleanConstant.TRUE;
            }
            return BooleanConstant.of(this.goperators.contains(gOperator));
        }

        @Override
        public Formula visit(MOperator mOperator) {
            if (this.isTrueFOperator(new FOperator(mOperator.left))) {
                return ROperator.of(mOperator.left.accept(this), mOperator.right.accept(this));
            }
            return BooleanConstant.FALSE;
        }

        @Override
        public Formula visit(UOperator uOperator) {
            if (this.isTrueFOperator(new FOperator(uOperator.right))) {
                return WOperator.of(uOperator.left.accept(this), uOperator.right.accept(this));
            }
            return BooleanConstant.FALSE;
        }

        @Override
        public Formula visit(ROperator rOperator) {
            return ROperator.of(rOperator.left.accept(this), rOperator.right.accept(this));
        }

        @Override
        public Formula visit(WOperator wOperator) {
            return WOperator.of(wOperator.left.accept(this), wOperator.right.accept(this));
        }
    }

    @VisibleForTesting
    static class GScopedSelectVisitor
    extends AbstractSelectVisitor {
        static final GScopedSelectVisitor INSTANCE = new GScopedSelectVisitor();

        GScopedSelectVisitor() {
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(FOperator fOperator) {
            List<Set<UnaryModalOperator>> sets = fOperator.operand.accept(FScopedSelectVisitor.INSTANCE);
            sets.forEach(x -> x.add(fOperator));
            return sets;
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(GOperator gOperator) {
            return gOperator.operand.accept(this);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(MOperator mOperator) {
            List<Set<Set>> left = mOperator.left.accept(FScopedSelectVisitor.INSTANCE);
            List right = mOperator.right.accept(this);
            FOperator fOperator = new FOperator(mOperator.left);
            left.forEach(x -> x.add(fOperator));
            return GScopedSelectVisitor.and(left, right);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(ROperator rOperator) {
            return this.visitR(rOperator.left, rOperator.right);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(UOperator uOperator) {
            List left = uOperator.left.accept(this);
            List<Set<Set>> right = uOperator.right.accept(FScopedSelectVisitor.INSTANCE);
            FOperator fOperator = new FOperator(uOperator.right);
            right.forEach(x -> x.add(fOperator));
            return GScopedSelectVisitor.or(right, GScopedSelectVisitor.and(left, right));
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(WOperator wOperator) {
            return this.visitW(wOperator.left, wOperator.right);
        }

        private List<Set<UnaryModalOperator>> visitR(Formula left, Formula right) {
            List leftSets = left.accept(this);
            List rightSets = right.accept(this);
            return GScopedSelectVisitor.or(rightSets, GScopedSelectVisitor.and(leftSets, rightSets));
        }

        private List<Set<UnaryModalOperator>> visitW(Formula left, Formula right) {
            List leftSets = left.accept(this);
            List rightSets = right.accept(this);
            return GScopedSelectVisitor.or(leftSets, GScopedSelectVisitor.and(leftSets, rightSets));
        }
    }

    @VisibleForTesting
    static class FScopedSelectVisitor
    extends AbstractSelectVisitor {
        static final FScopedSelectVisitor INSTANCE = new FScopedSelectVisitor();

        FScopedSelectVisitor() {
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(FOperator fOperator) {
            return fOperator.operand.accept(this);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(GOperator gOperator) {
            List<Set<UnaryModalOperator>> sets = gOperator.operand.accept(GScopedSelectVisitor.INSTANCE);
            sets.forEach(x -> x.add(gOperator));
            return sets;
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(MOperator mOperator) {
            return this.visitM(mOperator.left, mOperator.right);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(ROperator rOperator) {
            List<Set<Set>> gSet = rOperator.right.accept(GScopedSelectVisitor.INSTANCE);
            GOperator gOperator = new GOperator(rOperator.right);
            gSet.forEach(x -> x.add(gOperator));
            return FScopedSelectVisitor.or(gSet, this.visitM(rOperator.left, rOperator.right));
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(UOperator uOperator) {
            return this.visitU(uOperator.left, uOperator.right);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(WOperator wOperator) {
            List<Set<Set>> gSet = wOperator.left.accept(GScopedSelectVisitor.INSTANCE);
            GOperator gOperator = new GOperator(wOperator.left);
            gSet.forEach(x -> x.add(gOperator));
            return FScopedSelectVisitor.or(gSet, this.visitU(wOperator.left, wOperator.right));
        }

        private List<Set<UnaryModalOperator>> visitM(Formula left, Formula right) {
            List leftSets = left.accept(this);
            List rightSets = right.accept(this);
            return FScopedSelectVisitor.and(leftSets, rightSets);
        }

        private List<Set<UnaryModalOperator>> visitU(Formula left, Formula right) {
            List leftSets = left.accept(this);
            List rightSets = right.accept(this);
            return FScopedSelectVisitor.or(FScopedSelectVisitor.and(leftSets, rightSets), rightSets);
        }
    }

    @VisibleForTesting
    static abstract class AbstractSelectVisitor
    implements Visitor<List<Set<UnaryModalOperator>>> {
        AbstractSelectVisitor() {
        }

        protected static <T> List<Set<T>> and(List<Set<T>> conjunct1, List<Set<T>> conjunct2) {
            return AbstractSelectVisitor.and(List.of(conjunct1, conjunct2));
        }

        private static <T> List<Set<T>> and(Collection<List<Set<T>>> conjuncts) {
            ArrayList<Set<T>> intersection = new ArrayList<Set<T>>();
            for (List sets : Lists.cartesianProduct(List.copyOf(conjuncts))) {
                ConcurrentHashMap.KeySetView union = ConcurrentHashMap.newKeySet(sets.size());
                sets.parallelStream().forEach(union::addAll);
                Collections3.addDistinct(intersection, union);
            }
            return intersection;
        }

        protected static <T> List<Set<T>> or(Collection<List<Set<T>>> disjuncts, boolean upwardClosure) {
            ArrayList union = new ArrayList();
            if (!upwardClosure) {
                disjuncts.forEach(x -> Collections3.addAllDistinct(union, x));
                return union;
            }
            for (List sets : Lists.cartesianProduct(List.copyOf(disjuncts))) {
                for (Set activeSet : sets) {
                    Set otherSetsUnion = sets.stream().filter(x -> activeSet != x).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
                    for (Set x2 : Sets.powerSet(otherSetsUnion)) {
                        HashSet upwardClosedSet = Sets.newHashSet((Iterable)Iterables.concat((Iterable)activeSet, (Iterable)x2));
                        Collections3.addDistinct(union, upwardClosedSet);
                    }
                }
            }
            return union;
        }

        protected static <T> List<Set<T>> or(List<Set<T>> disjunct1, List<Set<T>> disjunct2) {
            return AbstractSelectVisitor.or(List.of(disjunct1, disjunct2), true);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? List.of(new HashSet()) : List.of();
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(Literal literal) {
            return List.of(new HashSet());
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(XOperator xOperator) {
            return xOperator.operand.accept(this);
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(Conjunction conjunction) {
            return AbstractSelectVisitor.and(Collections2.transform((Collection)conjunction.children, x -> x.accept(this)));
        }

        @Override
        public List<Set<UnaryModalOperator>> visit(Disjunction disjunction) {
            return AbstractSelectVisitor.or(Collections2.transform((Collection)disjunction.children, x -> x.accept(this)), true);
        }
    }

    static abstract class AbstractReplaceOperatorsVisitor
    implements Visitor<Formula> {
        AbstractReplaceOperatorsVisitor() {
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            return Conjunction.of(conjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            return Disjunction.of(disjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Literal literal) {
            return literal;
        }

        @Override
        public Formula visit(XOperator xOperator) {
            return XOperator.of(xOperator.operand.accept(this));
        }
    }
}

