/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.tlsf;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.immutables.value.Value;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.SyntacticFragment;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Converter;

@Value.Immutable
public abstract class Tlsf {
    @Value.Default
    public List<Formula> assert_() {
        return List.of();
    }

    @Value.Default
    public Formula assume() {
        return BooleanConstant.TRUE;
    }

    private Formula convert(Formula formula) {
        if (this.semantics().isMealy() && this.target().isMoore()) {
            return formula.accept(new MealyToMooreConverter());
        }
        if (this.semantics().isMoore() && this.target().isMealy()) {
            return formula.accept(new MooreToMealyConverter());
        }
        return formula;
    }

    public abstract String description();

    @Value.Default
    public List<Formula> guarantee() {
        return List.of();
    }

    @Value.Default
    public Formula initially() {
        return BooleanConstant.TRUE;
    }

    public abstract BitSet inputs();

    public abstract BitSet outputs();

    public abstract List<String> variables();

    @Value.Default
    public Formula preset() {
        return BooleanConstant.TRUE;
    }

    @Value.Default
    public Formula require() {
        return BooleanConstant.TRUE;
    }

    public abstract Semantics semantics();

    public abstract Semantics target();

    public abstract String title();

    @Value.Derived
    public int numberOfInputs() {
        return this.inputs().cardinality();
    }

    @Value.Derived
    public LabelledFormula toFormula() {
        return this.toFormula(Conjunction.of(this.assert_()), Conjunction.of(this.guarantee()));
    }

    private LabelledFormula toFormula(Formula assert_, Formula guarantee) {
        Formula formula = Disjunction.of(FOperator.of(this.require().not()), this.assume().not(), Conjunction.of(GOperator.of(assert_), guarantee));
        formula = this.semantics().isStrict() ? Conjunction.of(this.preset(), formula, WOperator.of(assert_, this.require().not())) : Conjunction.of(this.preset(), formula);
        Formula result = this.convert(Disjunction.of(this.initially().not(), formula));
        return LabelledFormula.of(result, this.variables(), this.inputs());
    }

    @Value.Derived
    public List<LabelledFormula> toAssertGuaranteeConjuncts() {
        ArrayList<LabelledFormula> conjuncts = new ArrayList<LabelledFormula>();
        this.assert_().forEach(x -> conjuncts.add(this.toFormula((Formula)x, BooleanConstant.TRUE)));
        this.guarantee().forEach(x -> conjuncts.add(this.toFormula(BooleanConstant.TRUE, (Formula)x)));
        return conjuncts;
    }

    @Value.Check
    protected void check() {
        boolean outputs = false;
        for (int i = 0; i < this.variables().size(); ++i) {
            Preconditions.checkState((boolean)(this.inputs().get(i) ^ this.outputs().get(i)), (Object)"'inputs' and 'outputs' must use distinct ids.");
            if (this.outputs().get(i)) {
                outputs = true;
            }
            if (!outputs) continue;
            Preconditions.checkState((!this.inputs().get(i) ? 1 : 0) != 0, (Object)"'inputs' should use lower numbers.");
        }
    }

    private final class MooreToMealyConverter
    extends Converter {
        private MooreToMealyConverter() {
            super(SyntacticFragment.ALL.classes());
        }

        @Override
        public Formula visit(Literal literal) {
            if (Tlsf.this.inputs().get(literal.getAtom())) {
                return XOperator.of(literal);
            }
            return literal;
        }
    }

    private final class MealyToMooreConverter
    extends Converter {
        private MealyToMooreConverter() {
            super(SyntacticFragment.ALL.classes());
        }

        @Override
        public Formula visit(Literal literal) {
            if (Tlsf.this.outputs().get(literal.getAtom())) {
                return XOperator.of(literal);
            }
            return literal;
        }
    }

    public static enum Semantics {
        MEALY,
        MEALY_STRICT,
        MOORE,
        MOORE_STRICT;


        public boolean isMealy() {
            return this == MEALY || this == MEALY_STRICT;
        }

        public boolean isMoore() {
            return !this.isMealy();
        }

        public boolean isStrict() {
            switch (this) {
                case MEALY_STRICT: 
                case MOORE_STRICT: {
                    return true;
                }
            }
            return false;
        }
    }
}

