/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.MOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class WOperator
extends BinaryModalOperator {
    public WOperator(Formula leftOperand, Formula rightOperand) {
        super(leftOperand, rightOperand);
    }

    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (leftOperand instanceof BooleanConstant || leftOperand instanceof GOperator || leftOperand.equals(rightOperand) || rightOperand.equals(BooleanConstant.TRUE)) {
            return Disjunction.of(leftOperand, rightOperand);
        }
        if (rightOperand.equals(BooleanConstant.FALSE)) {
            return GOperator.of(leftOperand);
        }
        return new WOperator(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public char getOperator() {
        return 'W';
    }

    @Override
    public boolean isPureEventual() {
        return false;
    }

    @Override
    public boolean isPureUniversal() {
        return false;
    }

    @Override
    public boolean isSuspendable() {
        return false;
    }

    @Override
    public Formula nnf() {
        return WOperator.of(this.left.nnf(), this.right.nnf());
    }

    @Override
    public Formula not() {
        return MOperator.of(this.left.not(), this.right.not());
    }

    @Override
    public Formula unfold() {
        return Disjunction.of(this.right.unfold(), Conjunction.of(this.left.unfold(), (Formula)this));
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return Disjunction.of(this.right.unfoldTemporalStep(valuation), Conjunction.of(this.left.unfoldTemporalStep(valuation), (Formula)this));
    }
}

