/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.UOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class ROperator
extends BinaryModalOperator {
    public ROperator(Formula leftOperand, Formula rightOperand) {
        super(leftOperand, rightOperand);
    }

    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (rightOperand instanceof BooleanConstant || rightOperand instanceof GOperator || leftOperand.equals(rightOperand) || leftOperand.equals(BooleanConstant.TRUE)) {
            return rightOperand;
        }
        if (leftOperand.equals(BooleanConstant.FALSE)) {
            return GOperator.of(rightOperand);
        }
        return new ROperator(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public char getOperator() {
        return 'R';
    }

    @Override
    public boolean isPureEventual() {
        return false;
    }

    @Override
    public boolean isPureUniversal() {
        return false;
    }

    @Override
    public boolean isSuspendable() {
        return false;
    }

    @Override
    public Formula nnf() {
        return ROperator.of(this.left.nnf(), this.right.nnf());
    }

    @Override
    public Formula not() {
        return UOperator.of(this.left.not(), this.right.not());
    }

    @Override
    public Formula unfold() {
        return Conjunction.of(this.right.unfold(), Disjunction.of(this.left.unfold(), (Formula)this));
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return Conjunction.of(this.right.unfoldTemporalStep(valuation), Disjunction.of(this.left.unfoldTemporalStep(valuation), (Formula)this));
    }
}

