/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import de.tum.in.naturals.bitset.BitSets;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;

final class DefaultImplementations {
    private DefaultImplementations() {
    }

    static <S> Set<S> visit(Automaton<S, ?> automaton, Automaton.EdgeVisitor<S> visitor) {
        HashSet<S> exploredStates = new HashSet<S>(automaton.initialStates());
        ArrayDeque<S> workQueue = new ArrayDeque<S>(exploredStates);
        Set powerSet = BitSets.powerSet((int)automaton.factory().alphabetSize());
        while (!workQueue.isEmpty()) {
            Object state = workQueue.remove();
            visitor.enter(state);
            for (BitSet valuation : powerSet) {
                for (Edge<S> edge : automaton.edges(state, valuation)) {
                    visitor.visitEdge(edge, valuation);
                    S successor = edge.successor();
                    if (!exploredStates.add(successor)) continue;
                    workQueue.add(successor);
                }
            }
            visitor.exit(state);
        }
        return exploredStates;
    }

    static <S> Set<S> visit(Automaton<S, ?> automaton, Automaton.LabelledEdgeVisitor<S> visitor) {
        HashSet exploredStates = new HashSet(automaton.initialStates());
        ArrayDeque workQueue = new ArrayDeque(exploredStates);
        while (!workQueue.isEmpty()) {
            Object state = workQueue.remove();
            visitor.enter(state);
            automaton.forEachLabelledEdge(state, (edge, valuation) -> {
                visitor.visitLabelledEdge(edge, (ValuationSet)valuation);
                Object successor = edge.successor();
                if (exploredStates.add(successor)) {
                    workQueue.add(successor);
                }
            });
            visitor.exit(state);
        }
        return exploredStates;
    }

    static <S> Set<S> getReachableStates(Automaton<S, ?> automaton) {
        HashSet<S> reachableStates = new HashSet<S>(automaton.initialStates());
        ArrayDeque<S> workQueue = new ArrayDeque<S>(reachableStates);
        while (!workQueue.isEmpty()) {
            for (S successor : automaton.successors(workQueue.remove())) {
                if (!reachableStates.add(successor)) continue;
                workQueue.add(successor);
            }
        }
        return reachableStates;
    }
}

