/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import owl.automaton.AutomatonUtil;
import owl.automaton.DefaultImplementations;
import owl.automaton.Properties;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;

public interface Automaton<S, A extends OmegaAcceptance> {
    default public String name() {
        return this.getClass() + " for " + this.initialStates();
    }

    public A acceptance();

    public ValuationSetFactory factory();

    default public S onlyInitialState() {
        Iterator<S> iterator = this.initialStates().iterator();
        S first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        throw new IllegalStateException("Multiple initial states: " + this.initialStates().toString());
    }

    public Set<S> initialStates();

    default public int size() {
        return this.states().size();
    }

    public Set<S> states();

    public Collection<Edge<S>> edges(S var1, BitSet var2);

    @Nullable
    default public Edge<S> edge(S state, BitSet valuation) {
        return (Edge)Iterables.getFirst(this.edges(state, valuation), null);
    }

    public Collection<Edge<S>> edges(S var1);

    default public void forEachEdge(S state, Consumer<Edge<S>> action) {
        this.edges(state).forEach(action);
    }

    public Collection<LabelledEdge<S>> labelledEdges(S var1);

    default public void forEachLabelledEdge(S state, BiConsumer<Edge<S>, ValuationSet> action) {
        this.labelledEdges(state).forEach(x -> action.accept(x.edge, x.valuations));
    }

    default public Set<S> successors(S state, BitSet valuation) {
        return new HashSet(Collections2.transform(this.edges(state, valuation), Edge::successor));
    }

    @Nullable
    default public S successor(S state, BitSet valuation) {
        return (S)Iterables.getFirst(this.successors(state, valuation), null);
    }

    public Set<S> successors(S var1);

    default public Set<S> predecessors(final S state) {
        final HashSet predecessors = new HashSet();
        HybridVisitor visitor = new HybridVisitor<S>(){
            boolean isPredecessor = false;

            @Override
            public void enter(S state2) {
                this.isPredecessor = false;
            }

            @Override
            public void exit(S state2) {
                if (this.isPredecessor) {
                    predecessors.add(state2);
                }
            }

            @Override
            public void visitEdge(Edge<S> edge, BitSet valuation) {
                if (!this.isPredecessor) {
                    this.isPredecessor = edge.successor().equals(state);
                }
            }

            @Override
            public void visitLabelledEdge(Edge<S> edge, ValuationSet valuationSet) {
                if (!this.isPredecessor) {
                    this.isPredecessor = edge.successor().equals(state);
                }
            }
        };
        this.accept(visitor);
        return predecessors;
    }

    default public void accept(EdgeVisitor<S> visitor) {
        DefaultImplementations.visit(this, visitor);
    }

    default public void accept(LabelledEdgeVisitor<S> visitor) {
        DefaultImplementations.visit(this, visitor);
    }

    default public void accept(HybridVisitor<S> visitor) {
        if (this.prefersLabelled()) {
            this.accept((LabelledEdgeVisitor<S>)visitor);
        } else {
            this.accept((EdgeVisitor<S>)visitor);
        }
    }

    public boolean prefersLabelled();

    default public boolean is(Property property) {
        switch (property) {
            case COMPLETE: {
                return Properties.isComplete(this);
            }
            case DETERMINISTIC: {
                return Properties.isDeterministic(this);
            }
            case SEMI_DETERMINISTIC: {
                return Properties.isSemiDeterministic(this);
            }
            case LIMIT_DETERMINISTIC: {
                if (this.acceptance() instanceof GeneralizedBuchiAcceptance) {
                    return AutomatonUtil.ldbaSplit(AutomatonUtil.cast(this, GeneralizedBuchiAcceptance.class)).isPresent();
                }
                return false;
            }
        }
        throw new UnsupportedOperationException("Property detection for " + property + " is not implemented");
    }

    public static interface HybridVisitor<S>
    extends EdgeVisitor<S>,
    LabelledEdgeVisitor<S> {
    }

    public static interface EdgeVisitor<S>
    extends Visitor<S> {
        public void visitEdge(Edge<S> var1, BitSet var2);
    }

    public static interface LabelledEdgeVisitor<S>
    extends Visitor<S> {
        public void visitLabelledEdge(Edge<S> var1, ValuationSet var2);
    }

    public static interface Visitor<S> {
        public void enter(S var1);

        public void exit(S var1);
    }

    public static enum Property {
        COMPLETE,
        DETERMINISTIC,
        SEMI_DETERMINISTIC,
        LIMIT_DETERMINISTIC;

    }
}

