/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.debug;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jdd.bdd.debug.BDDTrace;
import jdd.util.JDDConsole;
import jdd.util.Options;
import jdd.util.jre.JREInfo;

public class BDDTraceSuite {
    public BDDTraceSuite(String string, int n) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            JDDConsole.out.println("\n***** [ " + string + " ] *****");
            JREInfo.show();
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipInputStream.available() != 0) {
                String string2 = zipEntry.getName();
                if (string2.endsWith(".trace")) {
                    this.runTrace(string2, zipInputStream, n);
                } else if (string2.endsWith("README")) {
                    this.showFile(string2, zipInputStream);
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            JDDConsole.out.println("FAILED: " + iOException.getMessage() + "\n");
            iOException.printStackTrace();
            System.exit(20);
        }
    }

    private void runTrace(String string, InputStream inputStream, int n) {
        boolean bl = Options.verbose;
        Options.verbose = true;
        System.err.println("Tracing " + string + "...");
        try {
            if (n == -1) {
                new BDDTrace(string, inputStream);
            } else {
                new BDDTrace(string, inputStream, n);
            }
        }
        catch (Exception exception) {
            JDDConsole.out.println("FAILED: " + exception.getMessage() + "\n\n");
            exception.printStackTrace();
        }
        Options.verbose = bl;
        for (int i = 0; i < 6; ++i) {
            System.gc();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showFile(String string, InputStream inputStream) throws IOException {
        JDDConsole.out.println("File " + string);
        byte[] byArray = new byte[10240];
        int n;
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            JDDConsole.out.println(new String(byArray, 0, n));
        }
        return;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            new BDDTraceSuite(stringArray[0], -1);
        } else if (stringArray.length == 2) {
            new BDDTraceSuite(stringArray[0], Integer.parseInt(stringArray[1]));
        } else {
            System.err.println("Usage: java BDDTraceSuite <trace-suite.zip> [initial size _base_]");
        }
    }
}

