/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import jdd.bdd.NodeTable;
import jdd.util.Allocator;
import jdd.util.Dot;
import jdd.util.JDDConsole;
import jdd.util.NodeName;

public class BDDPrinter {
    private static final int NODE_MASK = Integer.MAX_VALUE;
    private static final int NODE_MARK = Integer.MIN_VALUE;
    private static NodeTable nt;
    private static PrintStream ps;
    private static NodeName nn;
    private static boolean had_0;
    private static boolean had_1;
    private static char[] set_chars;
    private static int set_chars_len;

    private static void helpGC() {
        ps = null;
        nn = null;
        nt = null;
    }

    private static final void print_unmark(int n) {
        if (n == 0 || n == 1) {
            return;
        }
        if (!nt.isNodeMarked(n)) {
            return;
        }
        nt.unmark_node(n);
        BDDPrinter.print_unmark(nt.getLow(n));
        BDDPrinter.print_unmark(nt.getHigh(n));
    }

    public static void print(int n, NodeTable nodeTable) {
        nt = nodeTable;
        JDDConsole.out.println("\nBDD " + n);
        BDDPrinter.print_rec(n);
        BDDPrinter.print_unmark(n);
        BDDPrinter.helpGC();
    }

    public static void print_rec(int n) {
        if (n < 2) {
            return;
        }
        if (nt.isNodeMarked(n)) {
            return;
        }
        JDDConsole.out.println("" + n + "\t" + nt.getVar(n) + "\t" + nt.getLow(n) + "\t" + nt.getHigh(n));
        nt.mark_node(n);
        BDDPrinter.print_rec(nt.getLow(n));
        BDDPrinter.print_rec(nt.getHigh(n));
    }

    public static void printDot(String string, int n, NodeTable nodeTable, NodeName nodeName) {
        try {
            ps = new PrintStream(new FileOutputStream(string));
            had_1 = false;
            had_0 = false;
            ps.println("digraph G {");
            nn = nodeName;
            nt = nodeTable;
            ps.println("\tinit__ [label=\"\", style=invis, height=0, width=0];");
            ps.println("\tinit__ -> " + n + ";");
            BDDPrinter.printDot_rec(n);
            if (had_0) {
                ps.println("0 [shape=box, label=\"" + nodeName.zeroShort() + "\", style=filled, shape=box, height=0.3, width=0.3];");
            }
            if (had_1) {
                ps.println("1 [shape=box, label=\"" + nodeName.oneShort() + "\", style=filled, shape=box, height=0.3, width=0.3];\n");
            }
            ps.println("}\n");
            BDDPrinter.print_unmark(n);
            ps.close();
            Dot.showDot(string);
            BDDPrinter.helpGC();
        }
        catch (IOException iOException) {
            JDDConsole.out.println("BDDPrinter.printDOT failed: " + iOException);
        }
    }

    private static void printDot_rec(int n) {
        if (n == 0) {
            had_0 = true;
            return;
        }
        if (n == 1) {
            had_1 = true;
            return;
        }
        if (nt.isNodeMarked(n)) {
            return;
        }
        int n2 = nt.getLow(n);
        int n3 = nt.getHigh(n);
        int n4 = nt.getVar(n);
        nt.mark_node(n);
        ps.println("" + n + "[label=\"" + nn.variable(n4) + ":" + n + "\"];");
        ps.println("" + n + "-> " + n2 + " [style=dotted];");
        ps.println("" + n + "-> " + n3 + " [style=filled];");
        BDDPrinter.printDot_rec(n2);
        BDDPrinter.printDot_rec(n3);
    }

    public static void printSet(int n, int n2, NodeTable nodeTable, NodeName nodeName) {
        if (n < 2) {
            if (nodeName != null) {
                JDDConsole.out.println(n == 0 ? nodeName.zero() : nodeName.one());
            } else {
                JDDConsole.out.println(n == 0 ? "FALSE" : "TRUE");
            }
        } else {
            if (set_chars == null || set_chars.length < n2) {
                set_chars = Allocator.allocateCharArray(n2);
            }
            set_chars_len = n2;
            nt = nodeTable;
            nn = nodeName;
            BDDPrinter.printSet_rec(n, 0);
            JDDConsole.out.println();
            BDDPrinter.helpGC();
        }
    }

    private static void printSet_rec(int n, int n2) {
        if (n2 == set_chars_len) {
            if (nn == null) {
                for (int i = 0; i < set_chars_len; ++i) {
                    JDDConsole.out.print(set_chars[i]);
                }
            } else {
                for (int i = 0; i < set_chars_len; ++i) {
                    if (set_chars[i] != '1') continue;
                    JDDConsole.out.print(" " + nn.variable(i));
                }
            }
            JDDConsole.out.println();
            return;
        }
        int n3 = nt.getVar(n);
        if (n3 > n2 || n == 1) {
            BDDPrinter.set_chars[n2] = 45;
            BDDPrinter.printSet_rec(n, n2 + 1);
            return;
        }
        int n4 = nt.getLow(n);
        int n5 = nt.getHigh(n);
        if (n4 != 0) {
            BDDPrinter.set_chars[n2] = 48;
            BDDPrinter.printSet_rec(n4, n2 + 1);
        }
        if (n5 != 0) {
            BDDPrinter.set_chars[n2] = 49;
            BDDPrinter.printSet_rec(n5, n2 + 1);
        }
    }

    static {
        set_chars = null;
    }
}

