/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.mocks;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.tools.mocks.MockIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockPluginDescriptor
extends MockIdentity
implements PluginDescriptor {
    private URL location;
    private String pluginClassName;
    private PluginRegistry registry;
    private String vendor;
    private Version version;
    private String docsPath;
    private Documentation<PluginDescriptor> documentation;
    private LinkedList<PluginAttribute> attributes = new LinkedList();
    private LinkedList<Extension> extensions = new LinkedList();
    private LinkedList<ExtensionPoint> extPoints = new LinkedList();
    private LinkedList<PluginFragment> fragments = new LinkedList();
    private LinkedList<Library> libraries = new LinkedList();
    private LinkedList<PluginPrerequisite> prerequisites = new LinkedList();

    public MockPluginDescriptor() {
    }

    public MockPluginDescriptor(String id) {
        this.setId(id);
    }

    public MockPluginDescriptor(String id, Version aVersion) {
        this.setId(id);
        this.setVersion(aVersion);
    }

    @Override
    public PluginAttribute getAttribute(String id) {
        for (PluginAttribute attr : this.attributes) {
            if (!attr.getId().equals(id)) continue;
            return attr;
        }
        throw new IllegalArgumentException("unknown attribute ID " + id);
    }

    @Override
    public Collection<PluginAttribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    @Override
    public Collection<PluginAttribute> getAttributes(String id) {
        LinkedList<PluginAttribute> result = new LinkedList<PluginAttribute>();
        for (PluginAttribute attr : this.attributes) {
            if (!attr.getId().equals(id)) continue;
            result.add(attr);
        }
        return result;
    }

    public MockPluginDescriptor addAttribute(PluginAttribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    @Override
    public Extension getExtension(String id) {
        for (Extension ext : this.extensions) {
            if (!ext.getId().equals(id)) continue;
            return ext;
        }
        throw new IllegalArgumentException("unknown extension ID " + id);
    }

    @Override
    public ExtensionPoint getExtensionPoint(String id) {
        for (ExtensionPoint extPoint : this.extPoints) {
            if (!extPoint.getId().equals(id)) continue;
            return extPoint;
        }
        throw new IllegalArgumentException("unknown extension point ID " + id);
    }

    @Override
    public Collection<ExtensionPoint> getExtensionPoints() {
        return Collections.unmodifiableCollection(this.extPoints);
    }

    @Override
    public Collection<Extension> getExtensions() {
        return Collections.unmodifiableCollection(this.extensions);
    }

    public MockPluginDescriptor addExtensionPoint(ExtensionPoint extPoint) {
        this.extPoints.add(extPoint);
        return this;
    }

    public MockPluginDescriptor addExtension(Extension extension) {
        this.extensions.add(extension);
        return this;
    }

    @Override
    public Collection<PluginFragment> getFragments() {
        return Collections.unmodifiableCollection(this.fragments);
    }

    public MockPluginDescriptor addFragment(PluginFragment fragment) {
        this.fragments.add(fragment);
        return this;
    }

    @Override
    public Collection<Library> getLibraries() {
        return Collections.unmodifiableCollection(this.libraries);
    }

    public MockPluginDescriptor addLibrary(Library library) {
        this.libraries.add(library);
        return this;
    }

    @Override
    public Library getLibrary(String id) {
        for (Library lib : this.libraries) {
            if (!lib.getId().equals(id)) continue;
            return lib;
        }
        throw new IllegalArgumentException("unknown library ID " + id);
    }

    @Override
    public URL getLocation() {
        return this.location;
    }

    public MockPluginDescriptor setLocation(URL value) {
        this.location = value;
        return this;
    }

    @Override
    public String getPluginClassName() {
        return this.pluginClassName;
    }

    public MockPluginDescriptor setPluginClassName(String value) {
        this.pluginClassName = value;
        return this;
    }

    @Override
    public PluginPrerequisite getPrerequisite(String id) {
        for (PluginPrerequisite pre : this.prerequisites) {
            if (!pre.getId().equals(id)) continue;
            return pre;
        }
        throw new IllegalArgumentException("unknown plug-in prerequisite ID " + id);
    }

    @Override
    public Collection<PluginPrerequisite> getPrerequisites() {
        return Collections.unmodifiableCollection(this.prerequisites);
    }

    public MockPluginDescriptor addPrerequisite(PluginPrerequisite pre) {
        this.prerequisites.add(pre);
        return this;
    }

    @Override
    public PluginRegistry getRegistry() {
        return this.registry;
    }

    public MockPluginDescriptor setRegistry(PluginRegistry value) {
        this.registry = value;
        return this;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    public MockPluginDescriptor setVendor(String value) {
        this.vendor = value;
        return this;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public MockPluginDescriptor setVersion(Version value) {
        this.version = value;
        return this;
    }

    @Override
    public String getUniqueId() {
        return this.getId() + '@' + this.getVersion();
    }

    @Override
    public String getDocsPath() {
        return this.docsPath;
    }

    public MockPluginDescriptor setDocsPath(String value) {
        this.docsPath = value;
        return this;
    }

    @Override
    public Documentation<PluginDescriptor> getDocumentation() {
        return this.documentation;
    }

    public MockPluginDescriptor setDocumentation(Documentation<PluginDescriptor> value) {
        this.documentation = value;
        return this;
    }
}

